// Copyright (C) 1999-2000 Open Source Telecom Corporation
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, permission is
// granted for additional uses of the text contained in its release
// of ACS as noted here.
//
// This exception is that permission is hereby granted to link ACS with
// the Pika MonteCarlo static libraries to produce a executable image
// without requiring MonteCarlo itself to be supplied in source form so
// long as each source file so linked contains this exclusion.
//
// This exception does not however invalidate any other reasons why
// the resulting executable file might be covered by the GNU General
// public license or invalidate the licensing requirements of any
// other component or library.
//
// This exception applies only to the code released by OST under the
// name ACS.  If you copy code from other releases into a copy of
// ACS, as the General Public License permits, the exception does not
// apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
//
// If you write modifications of your own to ACS, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice, at which
// point the terms of your modification would be covered under the GPL
// as explicitly stated in "COPYING".

#include <config.h>
#include <debug.h>
#include "pika.h"

void Trunk::Default(EventRecord *er)
{
	switch(er->event)
	{
	case UM_EVENT_START_LINE:
		if(er->p1)
			SendMessage(getPikaTrunk(--er->p1), er);
		break;
	case UM_EVENT_ENTER_STATE:
		Trace("Default");
		endTimer();
		break;
	case UM_EVENT_STOP_STATE:
		return scrExecute();
	case UM_EVENT_MAKE_BUSY:
		setHandler((handler_t)&Trunk::Busy);
		break;
	case PK_EVENT_TRUNK_LC_TERM:
		if(exeTrap() || trap)
			return;

		debug(1, "line %d; call terminated", id);
	case UM_EVENT_MAKE_IDLE:
		setHandler((handler_t)&Trunk::Idle);
		break;
	case UM_EVENT_EXIT_SHELL:
		exstatus = er->p1;
		waitpid = 0;
		break;
	case UM_EVENT_ERROR_ABORT:
		scrError((char *)er->p2);
		break;
	case PK_EVENT_TIMER_EXPIRED:
		return scrTimeout();
	case PK_EVENT_TRUNK_RINGING_OFF:
		++rings;
		break;
	case PK_EVENT_CID_REPORT:
		// printf("CID %d\n", er->p1);
		if(!er->p1)
		{
			// printf("CID BUFFER %s\n", cidbuf);
		}
		break;
	case PK_EVENT_DTMF_KEY_UP:
		if(er->p2 < 32)		// ignore if less than 32msec
			break;

		switch(er->p1)
		{
		case '0':
			return scrDigit(0);
		case '1':
			return scrDigit(1);
		case '2':
			return scrDigit(2);
		case '3':
			return scrDigit(3);
		case '4':
			return scrDigit(4);
		case '5':
			return scrDigit(5);
		case '6':
			return scrDigit(6);
		case '7':
			return scrDigit(7);
		case '8':
			return scrDigit(8);
		case '9':
			return scrDigit(9);
		case '*':
			return scrDigit(10);
		case '#':
			return scrDigit(11);
		case 'a':
		case 'A':
			return scrDigit(12);
		case 'b':
		case 'B':
			return scrDigit(13);
		case 'c':
		case 'C':
			return scrDigit(14);
		case 'd':
		case 'D':
			return scrDigit(15);
		}
	}
}

