// Copyright (C) 1999-2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, permission is
// granted for additional uses of the text contained in its release
// of ACS as noted here.
//
// This exception is that permission is hereby granted to link ACS with
// the Pika MonteCarlo static libraries to produce a executable image
// without requiring MonteCarlo itself to be supplied in source form so
// long as each source file so linked contains this exclusion.
//
// This exception does not however invalidate any other reasons why
// the resulting executable file might be covered by the GNU General
// public license or invalidate the licensing requirements of any
// other component or library.
//
// This exception applies only to the code released by OST under the
// name ACS.  If you copy code from other releases into a copy of
// ACS, as the General Public License permits, the exception does not
// apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
//
// If you write modifications of your own to ACS, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice, at which
// point the terms of your modification would be covered under the GPL
// as explicitly stated in "COPYING".

#include <config.h>
#include "server.h"
#include "pika.h"

static MappedFile *runfile = NULL;
static PKCard *cards = NULL;
static DSPDevice *devices = NULL;
static Session *session;

#define	PK_APPL_MASK	PK_AUDIO_IN_OUT | PK_FAX_TX_ONLY | PK_FAX_TX_RX

int initDriver(char *scr, int ports)
{
	PKCard *card;
	int count = PK_CTI_NumberOfBoards();
	int trunk = 0;
	File rundata(getkeyfirst(keypaths, "runfile"), FILE_OPEN_TRUNCATE, 0640);
	Runmap runmap, *map;
	memset(&runmap, 0, sizeof(runmap));
	strcpy(runmap.current, "INITIALIZING...");
	strcpy(runmap.schedule, "default");

	printf("starting driver for %d cards\n", count);
	if(count < 1)
	{
		throw(count);
		return -1;
	}

	cards = new PKCard[count];
	if(!cards)
	{
		throw(cards);
		return -1;
	}

	printf("before devices!\n");
	delay(100);
	count = getPikaDevices();
	if(!count)
	{
		throw(count);
		return -1;
	}

	devices = new DSPDevice[count];
	if(!devices)
	{
		throw(devices);
		return -1;
	}

	if(ports)
		setPikaTrunks(ports);

	count = getPikaTrunks();
	if(!count)
	{
		throw(count);
		return -1;
	}

	for(trunk = count; trunk > 0; --trunk)
		write(rundata, &runmap, sizeof(runmap));

	runfile = new MappedFile(getkeyfirst(keypaths, "runfile"), 0, sizeof(runmap) * count, FILE_MAPPED_RDWR);
	if(!runfile)
	{
		throw(count);
		return -1;
	}

	session = (Session *)new Session(count);
	//trunks = (Trunk **)new Trunk *[count];
	for(trunk = 0; trunk < count; ++trunk)
	{
		card = getTrunkCard();
		map = (Runmap *)runfile->Fetch(trunk * sizeof(runmap));
		Session::trunks[trunk] = new Trunk(card, map, scr);
	}

	return 0;
}

int stopDriver(void)
{
	int trunk = 0;

	sleep(2);

	if(!getPikaCards())
		return 0;

	sleep(1);

	while(Session::trunks && trunk < getPikaTrunks())
		delete Session::trunks[trunk++];

	if(session)
		delete session;

	stopPika();
	if(devices)
		delete[] devices;

	if(cards)
		delete[] cards;

	if(runfile)
		delete runfile;

	sleep(1);
}

