// Copyright (C) 1999-2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, permission is
// granted for additional uses of the text contained in its release
// of ACS as noted here.
//
// This exception is that permission is hereby granted to link ACS with
// the Pika MonteCarlo static libraries to produce a executable image
// without requiring MonteCarlo itself to be supplied in source form so
// long as each source file so linked contains this exclusion.
//
// This exception does not however invalidate any other reasons why
// the resulting executable file might be covered by the GNU General
// public license or invalidate the licensing requirements of any
// other component or library.
//
// This exception applies only to the code released by OST under the
// name ACS.  If you copy code from other releases into a copy of
// ACS, as the General Public License permits, the exception does not
// apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
//
// If you write modifications of your own to ACS, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice, at which
// point the terms of your modification would be covered under the GPL
// as explicitly stated in "COPYING".

#ifdef	HAVE_MONTECARLO_H
#include <MonteCarlo.h>
#else
#include <montecarlo.h>
#endif

#include <trunkmap.h>
#include <sessionmap.h>
#define	PK_VP_RESOURCES (PK_TONE_DETECTION | PK_TONE_GENERATION)
#define	USE_PK_CALL
#define	DSP
#define FAX
#define	DRIVER_TYPE	"PIKA"
#include <pk_mvip.h>
#include <pk_misc.h>
#include <pk_dsp.h>
#include <pk_vp.h>
#include <pk_cid.h>
#ifdef	CONFIG_PIKA_FAX
#include <pk_fax.h>
#endif
#ifdef	CONFIG_PIKA_FSK
#include <pk_fsk.h>
#endif

#define	UM_SERVER_EVENTS		0x8000
#define	UM_EVENT_ENTER_STATE		PK_MAKE_EVENT(UM_SERVER_EVENTS, 0)
#define	UM_EVENT_INITIALIZE_PORT	PK_MAKE_EVENT(UM_SERVER_EVENTS, 1)
#define UM_EVENT_MAKE_BUSY		PK_MAKE_EVENT(UM_SERVER_EVENTS, 2)
#define UM_EVENT_MAKE_IDLE		PK_MAKE_EVENT(UM_SERVER_EVENTS, 3)
#define	UM_EVENT_STOP_STATE		PK_MAKE_EVENT(UM_SERVER_EVENTS, 4)
#define	UM_EVENT_EXIT_SHELL		PK_MAKE_EVENT(UM_SERVER_EVENTS, 5)
#define UM_EVENT_START_LINE		PK_MAKE_EVENT(UM_SERVER_EVENTS, 6)
#define UM_EVENT_RING_LINE		PK_MAKE_EVENT(UM_SERVER_EVENTS, 7)
#define UM_EVENT_ERROR_ABORT		PK_MAKE_EVENT(UM_SERVER_EVENTS, 8)
#define UM_EVENT_EXIT_MODULE		PK_MAKE_EVENT(UM_SERVER_EVENTS, 9)

class PKCard;
class DSPDevice;
class Trunk;
class Audio;

typedef	struct
{
	PK_U32	event, p1, p2;
}	EventRecord;

typedef void PK_CALLBACK(*event_t)(PK_U32, PK_U32, PK_U32, PK_U32);
typedef	void (Trunk::*handler_t)(EventRecord *er);

class DSPDevice
{
private:
	static DSPDevice *first, *last;

	DSPDevice *next;
	PKCard	*card;
	int	dsp;
	int	id;
	TResourceHandle hDsp;

public:
	DSPDevice();
	~DSPDevice();

	friend TResourceHandle getDspResource(PK_WORD tag, DSPDevice *dsp = DSPDevice::first);
};

class PKCard
{
private:
	static int cards;
	static int trunks;
	static int devices;
	static PKCard *first;
	static PKCard *last;
	static PKCard *lastdsp;

	PKCard *next, *dspcard;
	DSPDevice *dspdevice;
	// TDeviceHandle hCard;
	bool active;
	TPortType trktype;
	int trkcount;
	int dspcount;
	int dspused;
	int trkused;
	int id;

public:
	PKCard();
	~PKCard();
	
	char *getname(char *buf);

	inline int getcard(void)
		{return id;};

	friend class DSPDevice;
	friend void stopPika(void);
	friend void startPika(void);
	friend PKCard *getTrunkCard(PK_WORD tag = 0);
	friend TPortHandle seizeTrunkPort(PKCard *card);
	friend void releaseTrunkPort(PKCard *card, TPortHandle port);
	friend void setPikaTrunks(int lines);

	friend inline int getPikaCards(void)
		{return PKCard::cards;};

	friend inline int getPikaDevices(void)
		{return PKCard::devices;};

	friend inline int getPikaTrunks(void)
		{return PKCard::trunks;};

	friend inline DSPDevice *getDspDevice(PKCard *card = PKCard::first)
		{return card->dspcard->dspdevice;};

	friend class Trunk;
};

class Trunk : public Trunkmap, public Mutex
{
private:
	static int ls_answer, ls_change, ls_dialtone;
	static char *ls_pattern;

	TResourceHandle hTimer, hDsp, hTrk;
	PKCard *card;
	bool playing;
	TBufferHeader ttsbuf;

	unsigned char cidbuf[PK_CID_BUFFER_SIZE];
	void resetThreads(void);

protected:
	char *runmap;
	Audio *audio;
	
	void Trace(char *id);
	void (Trunk::*handler)(EventRecord *er);
	void setHandler(handler_t h);
	void setTimer(PK_WORD timeout);
	void endTimer(void);
	void setDTMF(void);
	void endDTMF(void);
	void exitModule(char *errmsg, int id);
	void scrHangup(void);
	void scrStop(void);
	void scrStep(void);

	void scrFlash(void)
		{setHandler((handler_t)&Trunk::FlashOn);};
	
	void scrModule(void)
		{setHandler((handler_t)&Trunk::Module);};

	void scrSay(void)
		{setHandler((handler_t)&Trunk::Say);};

	void scrPlay(void)
		{setHandler((handler_t)&Trunk::Play);};

	void scrExWait(void)
		{setHandler((handler_t)&Trunk::ExWait);};

	void scrSleep(void)
		{setHandler((handler_t)&Trunk::TrkSleep);};

	void scrWait(void)
		{setHandler((handler_t)&Trunk::TrkWait);};

	void scrAnswer(void)
		{setHandler((handler_t)&Trunk::Answer);};

	void scrBusyout(void)
		{setHandler((handler_t)&Trunk::Busy);};

	void scrDial(void)
		{setHandler((handler_t)&Trunk::Dial);};

	void scrCollect(void)
		{setHandler((handler_t)&Trunk::Collect);};

	void scrRecord(void)
		{setHandler((handler_t)&Trunk::Record);};

	void Busy(EventRecord *er);
	void Idle(EventRecord *er);
	void Answer(EventRecord *er);
	void Default(EventRecord *er);
	void FlashOn(EventRecord *er);
	void FlashOff(EventRecord *er);

	void PostMessage(EventRecord *er);
	void TrkSleep(EventRecord *er);
	void TrkWait(EventRecord *er);
	void ExWait(EventRecord *er);
	void Module(EventRecord *er);
	void Say(EventRecord *er);
	void Play(EventRecord *er);
	void StopPlay(EventRecord *er);
	void StopSay(EventRecord *er);
	void Collect(EventRecord *er);
	void Record(EventRecord *er);
	void Dial(EventRecord *er);
	void Step(EventRecord *er);

public:
	Trunk(PKCard *card, Runmap *map, char *scr = NULL);
	virtual ~Trunk();

	friend void SendMessage(Trunk *trk, EventRecord *er);
};

class Session : public Sessionmap
{
private:
	static Trunk **trunks;

protected:
	void setIdle(int id);
	void setBusy(int id);
	void ringTrunk(int id);
	void callTrunk(int id, char *scr);
	void exitTGI(int id, int code);

public:
	Session(int count);
	~Session();

	inline Trunkmap* getTrunkHandler(int id)
		{return (Trunkmap *)getPikaTrunk(id);};

	inline int getTrunkCount(void)
		{return getPikaTrunks();};

	friend int initDriver(char *scr, int ports);
	friend int stopDriver(void);
	friend Trunk *getPikaTrunk(int id);

	friend class Trunk;
};

extern int stepping;
extern bool trace;
