// Copyright (C) 1999-2000 Open Source Telecom Corporation
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, permission is
// granted for additional uses of the text contained in its release
// of ACS as noted here.
//
// This exception is that permission is hereby granted to link ACS with
// the Pika MonteCarlo static libraries to produce a executable image
// without requiring MonteCarlo itself to be supplied in source form so
// long as each source file so linked contains this exclusion.
//
// This exception does not however invalidate any other reasons why
// the resulting executable file might be covered by the GNU General
// public license or invalidate the licensing requirements of any
// other component or library.
//
// This exception applies only to the code released by OST under the
// name ACS.  If you copy code from other releases into a copy of
// ACS, as the General Public License permits, the exception does not
// apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
//
// If you write modifications of your own to ACS, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice, at which
// point the terms of your modification would be covered under the GPL
// as explicitly stated in "COPYING".

#include <config.h>
#include <syslog.h>
#include "pika.h"
#include "audio.h"

void Trunk::StopPlay(EventRecord *er)
{
	switch(er->event)
	{
	case UM_EVENT_ENTER_STATE:
		Trace("playstop");
		if(!audio)
			break;

		PK_AUDIO_Reset(hDsp);
		PK_VP_DisableDTMFKeyDownEvent(hDsp);
		delete audio;
		audio = NULL;
	case PK_AUDIO_RETURN_BUFFER:
		setTimer(60);
	case UM_EVENT_STOP_STATE:
		return;
	case PK_AUDIO_OUTPUT_IDLE:
	case PK_EVENT_TIMER_EXPIRED:
		endTimer();
		break;
	default:
		Default(er);
		return;
	}
	scrExecute();
}

void Trunk::Play(EventRecord *er)
{
	int rtn;
	char *opt;
	char pathname[128];
	PBufferHeader pbuf;

	switch(er->event)
	{
	case PK_AUDIO_RETURN_BUFFER:
		if(!audio)
			return;
		
		pbuf = (PBufferHeader)(er->p1);
		if(pbuf->dwFlags & PK_AUDIO_LAST_BUFFER)
		{
			delete audio;
			audio = NULL;
		}
		else
			audio->PlayBuffer();
		return;
	
	case UM_EVENT_STOP_STATE:
		setHandler(&Trunk::StopPlay);
		return;
	
	case UM_EVENT_ENTER_STATE:
		Trace("play");
	case PK_AUDIO_OUTPUT_IDLE:
		if(!offhook)
		{	
			PK_CID_Disable(hDsp);
			rtn = PK_TRUNK_OffHook(hTrk);
			time(&starttime);
			offhook = true;
			if(rtn != PK_TRUNK_E_NOT_ONHOOK)
				return;
		}
		PK_VP_EnableDTMFKeyDownEvent(hDsp);
	case PK_EVENT_TRUNK_OFFHOOK:
		setDTMF();
		opt = getOption(NULL);
		if(!opt)
			break;
		if(!strnicmp(opt, "*:", 2))
		{
			strcpy(pathname, getLanguage());
			strcat(pathname, ":");
			strcat(pathname, opt + 2);
			opt = pathname;
		}
		audio = new PlayAudio(hDsp, opt, 0);
		audio->Post();
		return;
	case PK_EVENT_DTMF_KEY_DOWN:
		if(audio)
			PK_AUDIO_OutputPause(hDsp);
		return;
	case PK_EVENT_DTMF_KEY_UP:
		Default(er);
		if(audio)
			PK_AUDIO_OutputResume(hDsp);
		return;	
	default:
		Default(er);
		return;
	}
	PK_VP_DisableDTMFKeyDownEvent(hDsp);
	scrNext();
}
