// Copyright (C) 1999-2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, permission is
// granted for additional uses of the text contained in its release
// of ACS as noted here.
//
// This exception is that permission is hereby granted to link ACS with
// the Pika MonteCarlo static libraries to produce a executable image
// without requiring MonteCarlo itself to be supplied in source form so
// long as each source file so linked contains this exclusion.
//
// This exception does not however invalidate any other reasons why
// the resulting executable file might be covered by the GNU General
// public license or invalidate the licensing requirements of any
// other component or library.
//
// This exception applies only to the code released by OST under the
// name ACS.  If you copy code from other releases into a copy of
// ACS, as the General Public License permits, the exception does not
// apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
//
// If you write modifications of your own to ACS, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice, at which
// point the terms of your modification would be covered under the GPL
// as explicitly stated in "COPYING".

#include <config.h>
#include <syslog.h>
#include <cc++/thread.h>
#include <sys/stat.h>
#include "pika.h"
#include "audio.h"
#include "server.h"

PlayAudio::PlayAudio(TResourceHandle dsp, char *fname, long offset) :
Audio(dsp, fname, offset)
{
	total = loaded = 0;
};

PlayAudio::~PlayAudio()
{
	Terminate();
}

void PlayAudio::Silent(int frame)
{
	ENTER_DEFERRED
	loaded += Fill(frame, 0, PK_AUDIO_LAST_BUFFER);
	total = loaded;
	idle = true;
	PK_AUDIO_OutputAddBuffer(hDsp, &ctrl[frame]);
	LEAVE_DEFERRED
	return;
}	

void PlayAudio::Load(int frame)
{
	int flag = 0;
	int len;

	if(loaded >= total)
		return;

	len = read(fd, getFrameData(frame), getFrameSize());
	if(len < 0)
		syslog(LOG_WARNING, "%s: play failed", strrchr(pathname, '/') + 1);

	if(len <= 0)
		Silent(frame);
	else
	{
		ENTER_DEFERRED
		if(loaded + len >= total)
		{
			flag = PK_AUDIO_LAST_BUFFER;
			idle = true;
		}

		len = Fill(frame, len, flag);
		loaded += len;
		offset += len;
		PK_AUDIO_OutputAddBuffer(hDsp, &ctrl[frame]);
		LEAVE_DEFERRED
	}
}

void PlayAudio::Initial(void)
{
	int len;
	int frame = 0;
	struct stat ino;

	total = 0;
	loaded = 0;
	unsigned flag = 0;
	char *cp = strchr(pathname, ':');

	if(cp)
		*cp = '/';

	fd = open(pathname, O_RDONLY);
	if(fd > -1)
	{
		fstat(fd, &ino);
		if(offset > ino.st_size)
			offset = ino.st_size;

		if(getaulong(aufile.hdrsize))
			read(fd, &aufile, sizeof(aufile));
		
		if(offset < getaulong(aufile.hdrsize))
			offset = getaulong(aufile.hdrsize);

		lseek(fd, offset, SEEK_SET);
		total = ino.st_size - offset;
	}
	else
		syslog(LOG_WARNING, "%s: cannot play", strrchr(pathname, '/')+ 1);
		
	if(total < 1)
	{
		setFormat();	// default format for silence
		Silent(0);
		return;
	}

	setFormat(getaulong(aufile.encoding), getaulong(aufile.sampling));
	while(frame < frames && loaded < total)
		Load(frame++);	
}
 
void PlayAudio::Run(void)
{
	PK_AUDIO_OutputStart(hDsp);
	int frame = 0;
	setCancel(THREAD_CANCEL_IMMEDIATE);

	for(;;)
	{
		Wait();
		Load(frame++);
		if(frame >= frames)
			frame = 0;
	}
}

bool PlayAudio::PlayBuffer(void)
{
	if(loaded >= total)
		return false;

	Post();
	return true;
}

