// Copyright (C) 1999-2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, permission is
// granted for additional uses of the text contained in its release
// of ACS as noted here.
//
// This exception is that permission is hereby granted to link ACS with
// the Pika MonteCarlo static libraries to produce a executable image
// without requiring MonteCarlo itself to be supplied in source form so
// long as each source file so linked contains this exclusion.
//
// This exception does not however invalidate any other reasons why
// the resulting executable file might be covered by the GNU General
// public license or invalidate the licensing requirements of any
// other component or library.
//
// This exception applies only to the code released by OST under the
// name ACS.  If you copy code from other releases into a copy of
// ACS, as the General Public License permits, the exception does not
// apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
//
// If you write modifications of your own to ACS, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice, at which
// point the terms of your modification would be covered under the GPL
// as explicitly stated in "COPYING".

#include <config.h>
#include <syslog.h>
#include <cc++/thread.h>
#include <sys/stat.h>
#include "pika.h"
#include "audio.h"
#include "server.h"

RecordAudio::RecordAudio(TResourceHandle dsp, char *fname, long offset) :
Audio(dsp, fname, offset) 
{
	recording = true;
	newfile = false;
	framepos = 0;
};

RecordAudio::~RecordAudio()
{
	int frame = framepos;
	long len;

	Terminate();
	recording = false;

	if(fd < 0)
		return;

	// clean up un-returned frames...is this a bug in the driver?

	while(hasFormat())
	{
		Save(framepos++, true);
		framepos %= frames;
		if(framepos == frame)
			break;
	}

	if(newfile && offset < getBufferSize() * atoi(getkeylast(keyaudio, "min")))
	{
		remove(pathname);
		return;		
	}
	
	if(newfile || (offset > total))
	{
		len = offset - getBufferSize() * atoi(getkeylast(keyaudio, "trim"));		
		ftruncate(fd, len);
		setaulong(aufile.datasize, len);
		if(getaulong(aufile.hdrsize))
		{
			lseek(fd, 0l, SEEK_SET);
			write(fd, &aufile, sizeof(aufile));
		}
	}			
}

void RecordAudio::Save(int frame, bool override)
{
	int flag = 0;
	int len;

	if(!recording && !override)
		return;

	len = ctrl[frame].dwBytesRecorded;
	if(len > 0)
		len = write(fd, getFrameData(frame), len);

	if(len < 0)
		syslog(LOG_WARNING, "%s: write failed", strrchr(pathname, '/') + 1);

	ENTER_DEFERRED
	if(len <= 0)
		recording = false;
	else
	{
		offset += len;
		if(!override)
			Empty(frame, 0);		
		else
			ctrl[frame].dwBytesRecorded = 0;
	}
	LEAVE_DEFERRED
}

void RecordAudio::Initial(void)
{
	int len;
	int frame = 0;
	int idle = true;
	struct stat ino;

	if(offset)
		fd = open(pathname, O_WRONLY);
	else
	{
		fd = open(pathname, O_WRONLY | O_CREAT | O_TRUNC, 0660);
		newfile = true;
	}

	if(fd > -1)
	{
		fstat(fd, &ino);

		if(!newfile && getaulong(aufile.hdrsize) > 0)
			read(fd, &aufile, sizeof(aufile));

		if(offset < getaulong(aufile.hdrsize))
			offset = getaulong(aufile.hdrsize);		

		setFormat(getaulong(aufile.encoding), getaulong(aufile.sampling));
		lseek(fd, offset, SEEK_SET);
		total = ino.st_size;
	}
	else
	{
		syslog(LOG_WARNING, "%s: cannot record", strrchr(pathname, '/')+ 1);
		recording = false;
	}

	if(!hasFormat())
		return;

	while(frame < frames)
		Empty(frame++, 0);	
}

bool RecordAudio::RecordBuffer(void)
{
	if(recording && hasFormat())
		Post();

	return recording;
}

void RecordAudio::Run(void)
{
	PK_AUDIO_InputStart(hDsp);
	setCancel(THREAD_CANCEL_IMMEDIATE);

	for(;;)
	{
		Wait();
		if(!hasFormat())
			continue;

		Save(framepos++, false);
		if(framepos >= frames)
			framepos = 0;
	}
}

