// Copyright (C) 1999-2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, permission is
// granted for additional uses of the text contained in its release
// of ACS as noted here.
//
// This exception is that permission is hereby granted to link ACS with
// the Pika MonteCarlo static libraries to produce a executable image
// without requiring MonteCarlo itself to be supplied in source form so
// long as each source file so linked contains this exclusion.
//
// This exception does not however invalidate any other reasons why
// the resulting executable file might be covered by the GNU General
// public license or invalidate the licensing requirements of any
// other component or library.
//
// This exception applies only to the code released by OST under the
// name ACS.  If you copy code from other releases into a copy of
// ACS, as the General Public License permits, the exception does not
// apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
//
// If you write modifications of your own to ACS, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice, at which
// point the terms of your modification would be covered under the GPL
// as explicitly stated in "COPYING".

#include <config.h>
#include "server.h"
#include "pika.h"

Trunk **Session::trunks = NULL;

Session::Session(int count) : Sessionmap()
{
	trunks = (Trunk **)new Trunk *[count];
}

Session::~Session() 
{
	delete[] trunks;
}

void Session::setBusy(int id)
{
	EventRecord er;
	Trunk *trunk = getPikaTrunk(id);

	if(!trunk)
		return;

	er.event = UM_EVENT_MAKE_BUSY;
	er.p1 = er.p2 = 0;
	SendMessage(trunk, &er);
}

void Session::setIdle(int id)
{
	EventRecord er;
	Trunk *trunk = getPikaTrunk(id);

	if(!trunk)
		return;

	er.event = UM_EVENT_MAKE_IDLE;
	er.p1 = er.p2 = 0;
	SendMessage(trunk, &er);
}

void Session::exitTGI(int id, int excode)
{
	EventRecord er;
	Trunk *trunk = getPikaTrunk(id);

	if(!trunk)
		return;

	er.event = UM_EVENT_EXIT_SHELL;
	er.p1 = excode;
	er.p2 = 0;
	SendMessage(trunk, &er);
}

void Session::ringTrunk(int id)
{
	EventRecord er;
	Trunk *trunk = getPikaTrunk(id);

	if(!trunk)
		return;

	er.event = UM_EVENT_RING_LINE;
	er.p1 = er.p2 = 0;
	SendMessage(trunk, &er);
}

void Session::callTrunk(int id, char *scr)
{
	bool search = false;
	EventRecord er;
	Trunk *trunk;
		
	if(!id)
	{
		id = getPikaTrunks();
		search = true;
	}

	trunk = getPikaTrunk(id);
	if(!trunk)
		return;

	if(search)
		er.p1 = id;
	else
		er.p1 = 0;
	SendMessage(trunk, &er);
}

Trunk* getPikaTrunk(int id)
{
	if(id < 1 || id > getPikaTrunks())
		return NULL;

	return Session::trunks[--id];
}


