// Copyright (C) 1999-2000 Open Source Telecom Corporation
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, permission is
// granted for additional uses of the text contained in its release
// of ACS as noted here.
//
// This exception is that permission is hereby granted to link ACS with
// the Pika MonteCarlo static libraries to produce a executable image
// without requiring MonteCarlo itself to be supplied in source form so
// long as each source file so linked contains this exclusion.
//
// This exception does not however invalidate any other reasons why
// the resulting executable file might be covered by the GNU General
// public license or invalidate the licensing requirements of any
// other component or library.
//
// This exception applies only to the code released by OST under the
// name ACS.  If you copy code from other releases into a copy of
// ACS, as the General Public License permits, the exception does not
// apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
//
// If you write modifications of your own to ACS, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice, at which
// point the terms of your modification would be covered under the GPL
// as explicitly stated in "COPYING".

#include <config.h>
#include "pika.h"
#include "audio.h"

extern bool trace;

static void PK_CALLBACK callTrunk(Trunk *trk, PK_U32 event, PK_U32 p1, PK_U32 p2)	
{
	EventRecord er;

	if(!trk)
		return;

	er.event = event;
	er.p1 = p1;
	er.p2 = p2;
	SendMessage(trk, &er);
}		

int	Trunk::ls_answer = 3000;
int	Trunk::ls_change = 8000;
int	Trunk::ls_dialtone = 3000;
char	*Trunk::ls_pattern = NULL;

Trunk::Trunk(PKCard *pkcard, Runmap *map, char *scr) : 
Trunkmap(map, scr), Mutex()
{
	card = pkcard;
	DSPDevice *dsp = getDspDevice(card);

	audio = NULL;
	hTimer = PK_TIMER_Create();
	hDsp = getDspResource(PK_VP_RESOURCES, dsp);

	hTrk = PK_TRUNK_SeizeResource(card->id, (TNetworkInterfaceType)PK_LS_PORT);

	if(!hTrk)
	{
		card->trktype = PK_DID_PORT;
		hTrk = PK_TRUNK_SeizeResource(card->id, (TNetworkInterfaceType)PK_DID_PORT);
	}
	if(!hTrk)
	{
		card->trktype = PK_EM_PORT;
		hTrk = PK_TRUNK_SeizeResource(card->id, (TNetworkInterfaceType)PK_EM_PORT);
	}
	if(hTrk)
		++card->trkused;
	else
		card->trktype = PK_NONE_PORT;
	
	if(!hTimer || !hDsp || !hTrk || !card)
		throw(this);

	setCurrent("STARTING...");	

	handler = (handler_t)&Trunk::Idle;
	PK_MVIP_FullDuplexConnect(hTrk, hDsp);
	PK_TIMER_SetEventHandler(hTimer, (PK_U32)this, (event_t)&callTrunk);
	PK_DSP_SetEventHandler(hDsp, (PK_U32)this, (event_t)&callTrunk);
	PK_TRUNK_SetEventHandler(hTrk, (PK_U32)this, (event_t)&callTrunk);
	PK_TRUNK_CallOfferDetection(hTrk, PK_TRUE);
	PK_TRUNK_DisconnectDetection(hTrk, PK_TRUE);
	setHandler((handler_t)&Trunk::Idle);
}

Trunk::~Trunk() 
{
	PK_AUDIO_Reset(hDsp);
	PK_TRUNK_OnHook(hTrk);
	PK_MVIP_Disconnect(hTrk, hDsp);
	PK_TIMER_SetEventHandler(hTimer, 0, (event_t)&callTrunk);
	PK_DSP_SetEventHandler(hDsp, 0, (event_t)&callTrunk);
	PK_TRUNK_SetEventHandler(hTrk, 0, (event_t)&callTrunk);
	PK_TIMER_Delete(hTimer);
	PK_DSP_ReleasePort(hDsp);
	PK_TRUNK_ReleaseResource(hTrk);
	--card->trkused;
}

void Trunk::PostMessage(EventRecord *er)
{
	char tbuf[65];
	switch(er->event)
	{
	case PK_EVENT_TIMER_EXPIRED:
		if(!timer)
			return;
		break;
	case PK_EVENT_DTMF_KEY_UP:
	case PK_EVENT_DTMF_KEY_DOWN:
		if(!dtmf)
			return;
		break;
	}
	if(trace)
	{
		sprintf(tbuf, "event %ld %ld %ld",
			er->event, er->p1, er->p2);
		Trace(tbuf);
	}
	(this->*handler)(er);
}

void Trunk::setHandler(handler_t h)
{
	EventRecord e;
	
	e.event = UM_EVENT_ENTER_STATE;
	e.p1 = 0;
	e.p2 = 0;
	handler = h;
	PostMessage(&e);
}

void Trunk::exitModule(char *errmsg, int id)
{
	EventRecord e;

	e.event = UM_EVENT_EXIT_MODULE;
	e.p1 = (PK_U32)(errmsg);
	e.p2 = id;
	PostMessage(&e);
}

void Trunk::scrStep(void)
{
	if(stepping)
		setHandler((handler_t)&Trunk::Step);
	else
		return scrNext();
}

void Trunk::scrHangup(void)
{
	if(trap && waitpid)
		waitpid = 0;

	trap = false;
	setHandler((handler_t)&Trunk::Idle);
}

void Trunk::scrStop(void)
{
	EventRecord e;

	e.event = UM_EVENT_STOP_STATE;
	e.p1 = 0;
	e.p2 = 0;
	PostMessage(&e);
}		

void Trunk::setDTMF(void)
{
	if(dtmf)
		return;

	dtmf = true;
	PK_VP_EnableDTMFDetection(hDsp);
	PK_VP_DisableDTMFKeyDownEvent(hDsp);
	PK_VP_DisableEnergyMeter(hDsp);
}

void Trunk::endDTMF(void)
{
	if(!dtmf)
		return;

	dtmf = false;
	PK_VP_DisableDTMFDetection(hDsp);
}

void Trunk::setTimer(PK_WORD timeout)
{
	timer = timeout;
	PK_TIMER_Start(hTimer, timeout);
}

void Trunk::endTimer(void)
{
	timer = 0;
	PK_TIMER_Stop(hTimer);
}

void Trunk::resetThreads(void)
{
	if(audio)
	{
		delete audio;
		audio = NULL;
	}
	if(mailbox)
	{
		delete mailbox;
		mailbox = NULL;
	}
	if(waitpid)
	{
		kill(waitpid, SIGHUP);
		waitpid = 0;
	}
}

void Trunk::Trace(char *msg)
{
	struct timeval tv;
	struct tm *dt;
	if(!trace)
		return;

	gettimeofday(&tv, NULL);
	dt = localtime(&tv.tv_sec);
	printf("%02d:%02d:%0d2 `%03d trace(%d) %s\n",
		dt->tm_hour, dt->tm_min, dt->tm_sec,
		tv.tv_usec / 1000, id, msg);
}	

void SendMessage(Trunk *trk, EventRecord *er)
{
	trk->EnterMutex();
	trk->PostMessage(er);
	trk->LeaveMutex();
};


