// Copyright (C) 1999-2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, permission is
// granted for additional uses of the text contained in its release
// of ACS as noted here.
//
// This exception is that permission is hereby granted to link ACS with
// the Pika MonteCarlo static libraries to produce a executable image
// without requiring MonteCarlo itself to be supplied in source form so
// long as each source file so linked contains this exclusion.
//
// This exception does not however invalidate any other reasons why
// the resulting executable file might be covered by the GNU General
// public license or invalidate the licensing requirements of any
// other component or library.
//
// This exception applies only to the code released by OST under the
// name ACS.  If you copy code from other releases into a copy of
// ACS, as the General Public License permits, the exception does not
// apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
//
// If you write modifications of your own to ACS, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice, at which
// point the terms of your modification would be covered under the GPL
// as explicitly stated in "COPYING".

#include <config.h>
#include <trunkmap.h>
#include <module.h>
#include <database.h>
#include <debug.h>
#include <sym.h>
#include <keydata.h>
#include <stdlib.h>

int Script::getdigit(char dig)
{
	int cnt = 0;

	while(cnt < 16)
	{
		if(dig == dtmfkeys[cnt])
			return cnt;
		++cnt;
	}
}	

int Script::Compile(char *path, keydata_t *keyscript)
{
	char *argv[33];
	int argc;
	char lbuf[256];
	char *name, *p;
	Menu *menu;
	Command *lastcmd = NULL, *cmdline;
	char *cmd, *strcmd;
	unsigned key;
	int lines = 0;
	int digit;
	script_t scr = NULL;
	Module *module;

	FILE *fp = fopen(path, "r");
	if(!fp)
		return 0;

	name = strrchr(path, '/');
	if(name)
		++name;
	else
		name = path;

	p = strrchr(name, '.');
	if(p)
		*p = 0;

	key = keyindex(name);
	menu = (Menu *)alloc(sizeof(Menu));
	menu->TRAP = NULL;
	menu->name = dupstr(name);
	menu->mask = 0l;
	menu->next = keys[key];
	menu->first = NULL;
	keys[key] = menu;
	unsigned long mask = 0;
	unsigned long prep;

	for(;;)
	{
		scr = NULL;
		module = NULL;
		fgets(lbuf, sizeof(lbuf) - 1, fp);
		if(feof(fp))
			break;

		p = lbuf;
		while(*p == ' ' || *p == '\t' || *p == '\n')
			++p;
	
		if(*p == '#' || *p == ';' || !*p)
			continue;

		while(*p >= '0' && *p <= '9')
		{
			digit = *p - '0';
			if(menu->L[digit] == menu->first)
				menu->L[digit] = NULL;	
			++p;
		}

		if(*p == '^')
		{
			if(lastcmd)
			{
				lastcmd = NULL;
				mask = 0;
			}

			switch(*(++p))
			{
			case '!':
				if(menu->mask == 0x3ffff)
					break;

				mask = 0x3ffff;
				for(digit = 0; digit < 16; ++ digit)
				{
					if(menu->D[digit] == menu->first)
						menu->D[digit] = NULL;
				}
				if(menu->TO == menu->first)
					menu->TO = NULL;
				if(menu->ERR == menu->first)
					menu->ERR = NULL;
				break;
			case 'E':
				if(menu->ERR == menu->first)
					break;
				mask |= ERROR_MASK;
				break;
			case 'T':
				if(menu->TO == menu->first)
					break;
				mask |= TIMEOUT_MASK;
				break;				
			default:
				digit = getdigit(*p);
				if(digit > 15)
					break;

				if(menu->D[digit] == menu->first)
				{
					menu->D[digit] = NULL;
					mask |= (1 << digit);
				}
			}
			if(!mask)
				continue;

			menu->mask |= mask;
			++p;
		}

		while(*p == ' ' || *p == '\t' || *p == '\n')
			++p;

		if(!*p || *p == '#' || *p == ';')
			continue;
		
		cmd = strcmd = strtok(p, " \t\n");

		if(!stricmp(cmd, "initialize"))
		{
			cmd = strtok(NULL, " \t\n");
			p = strtok(NULL, " \t\n");
			if(!getsym(cmd, 0))
				setsym(cmd, p, 0);
			continue;
		}

		if(!stricmp(cmd, "flash"))
			scr = &Trunkmap::scrFlash;

		if(!stricmp(cmd, "messages"))
			scr = &Trunkmap::scrMessages;

		if(!stricmp(cmd, "skip"))
			scr = &Trunkmap::scrSkip;

		if(!stricmp(cmd, "drop"))
			scr = &Trunkmap::scrDrop;

		if(!stricmp(cmd, "save"))
			scr = &Trunkmap::scrSave;

		if(!stricmp(cmd, "add"))
			scr = &Trunkmap::scrAdd;

		if(!stricmp(cmd, "trim"))
			scr = &Trunkmap::scrTrim;

		if(!stricmp(cmd, "clear"))
			scr = &Trunkmap::scrClear;

		if(!stricmp(cmd, "hangup"))
			scr = &Trunkmap::scrHangup;

		if(!stricmp(cmd, "busyout") || !stricmp(cmd, "busy"))
			scr = &Trunkmap::scrBusyout;

		if(!stricmp(cmd, "answer"))
			scr = &Trunkmap::scrAnswer;

		if(!stricmp(cmd, "wait"))
			scr = &Trunkmap::scrWait;

		if(!stricmp(cmd, "libexec"))
			scr = &Trunkmap::scrLibexec;

		if(!stricmp(cmd, "trace"))
			scr = &Trunkmap::scrTrace;
	
		if(!stricmp(cmd, "sleep"))
			scr = &Trunkmap::scrSleep;

		if(!stricmp(cmd, "print") || !stricmp(cmd, "log"))
			scr = &Trunkmap::scrLog;

		if(!stricmp(cmd, "exists"))
			scr = &Trunkmap::scrExists;

		if(!stricmp(cmd, "call") || !stricmp(cmd, "gosub"))
			scr = &Trunkmap::scrCall;

		if(!stricmp(cmd, "return"))
			scr = &Trunkmap::scrReturn;

		if(!stricmp(cmd, "pop"))
			scr = &Trunkmap::scrPop;

		if(!stricmp(cmd, "prefix"))
			scr = &Trunkmap::scrPrefix;

		if(!stricmp(cmd, "erase"))
			scr = &Trunkmap::scrErase;

		if(!stricmp(cmd, "link"))
			scr = &Trunkmap::scrLink;

		if(!stricmp(cmd, "move"))
			scr = &Trunkmap::scrMove;

		if(!stricmp(cmd, "select"))
			scr = &Trunkmap::scrSelect;

		if(!stricmp(cmd, "trap"))
			scr = &Trunkmap::scrTrap;

		if(!stricmp(cmd, "start") || !stricmp(cmd, "goto"))
			scr = &Trunkmap::scrGoto;
		
		if(!stricmp(cmd, "init"))
			scr = &Trunkmap::scrInit;

		if(!stricmp(cmd, "define"))
			scr = &Trunkmap::scrDefine;

		if(!stricmp(cmd, "if"))
			scr = &Trunkmap::scrIf;

		if(!stricmp(cmd, "first"))
			scr = &Trunkmap::scrFirstItem;

		if(!stricmp(cmd, "last"))
			scr = &Trunkmap::scrLastItem;

		if(!stricmp(cmd, "list"))
			scr = &Trunkmap::scrList;

		if(!stricmp(cmd, "next"))
			scr = &Trunkmap::scrNextItem;

		if(!stricmp(cmd, "prev"))
			scr = &Trunkmap::scrPrevItem;

		if(!stricmp(cmd, "set"))
			scr = &Trunkmap::scrSet;

		if(!stricmp(cmd, "say"))
			scr = &Trunkmap::scrSay;

		if(!stricmp(cmd, "play"))
			scr = &Trunkmap::scrPlay;

		if(!stricmp(cmd, "record"))
			scr = &Trunkmap::scrRecord;

		if(!stricmp(cmd, "collect"))
			scr = &Trunkmap::scrCollect;

		if(!stricmp(cmd, "dial"))
			scr = &Trunkmap::scrDial;

#ifdef	HAVE_MODULES
		if(!scr)
		{
			if(!stricmp(cmd, "commit"))
				scr = &Trunkmap::scrCommit;
	
			if(!stricmp(cmd, "mailbox"))
				scr = &Trunkmap::scrMailbox;

			if(!stricmp(cmd, "extension"))
				scr = &Trunkmap::scrExtension;

			if(!stricmp(cmd, "deliver"))
				scr = &Trunkmap::scrDeliver;
		
			if(scr)
				module = getModule(MODULE_MBI);
		}
		if(!scr)
		{
			if(!stricmp(cmd, "insert"))
				scr = &Trunkmap::scrInsert;

			if(!stricmp(cmd, "delete"))
				scr = &Trunkmap::scrDelete;

			if(!stricmp(cmd, "update"))
				scr = &Trunkmap::scrUpdate;

			if(!stricmp(cmd, "search"))
				scr = &Trunkmap::scrSearch;

			if(scr)
				module = getModule(MODULE_DBI);
		}

		if(!scr)
		{
			module = getModule(cmd);
			if(module)
				scr = &Trunkmap::scrModule;
		}
#endif

		if(!scr)
		{
			debug(3, "*** %s: unknown keyword", cmd);
			continue;		
		}

		++lines;
		argc = 0;
		while(NULL != (cmd = strtok(NULL, " \t\n")) && argc < 32)
		{
			if(*cmd == '#')
				break;

			if(*cmd == '$')
				cmd = getkeyfirst(keyscript, ++cmd);
			else
			{
				if(*cmd == '\"')
				{
					p = strchr(++cmd, '\"');
					if(p)
						*p = 0;
				}
				else if(*cmd == '\'')
				{
					p = strchr(++cmd, '\'');
					if(p)
						*p = 0;
				}
				cmd = dupstr(cmd);
			}
			if(!cmd)
				continue;

			argv[argc++] = cmd;
		}
		argv[argc++] = NULL;

		cmdline = (Command *)alloc(sizeof(Command));
		if(!menu->first)
		{
			menu->first = menu->TO = menu->ERR = cmdline;
			for(digit = 0; digit < 16; ++digit)
				menu->D[digit] = cmdline;
			for(digit = 0; digit < 10; ++digit)
				menu->L[digit] = cmdline;
		}

		if(lastcmd)
			lastcmd->next = cmdline;

		for(digit = 0; digit < 16; ++digit)
		{
			if(!menu->D[digit])
				menu->D[digit] = cmdline;
		}

		for(digit = 0; digit < 10; ++digit)
		{
			if(!menu->L[digit])
				menu->L[digit] = cmdline;
		}

		if(!menu->TO)
			menu->TO = cmdline;

		if(!menu->ERR)
			menu->ERR = cmdline;

		cmdline->cmd = dupstr(strcmd);
		cmdline->next = menu->first;
		cmdline->mask = mask;
		cmdline->scrHandler = scr;
		cmdline->module = module;
		cmdline->line = lines;
		cmdline->argv = (char **)alloc(argc * sizeof(char *));
		memcpy(cmdline->argv, &argv, argc * sizeof(char *));
		lastcmd = cmdline; 			
	}

	fclose(fp);
	if(lines)
	{
		if(!menu->TO)
			menu->TO = menu->first;

		if(!menu->ERR)
			menu->ERR = menu->first;

		for(digit = 0; digit < 10; ++digit)
		{
			if(!menu->L[digit])
				menu->L[digit] = menu->first;
		}

		for(digit = 0; digit < 16; ++digit)
		{
			if(!menu->D[digit])
				menu->D[digit] = menu->first;
		}
		menu->next = keys[key];
		keys[key] = menu;
	}
	return lines;	
}
