// Copyright (C) 1999-2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, permission is
// granted for additional uses of the text contained in its release
// of ACS as noted here.
//
// This exception is that permission is hereby granted to link ACS with
// the Pika MonteCarlo static libraries to produce a executable image
// without requiring MonteCarlo itself to be supplied in source form so
// long as each source file so linked contains this exclusion.
//
// This exception does not however invalidate any other reasons why
// the resulting executable file might be covered by the GNU General
// public license or invalidate the licensing requirements of any
// other component or library.
//
// This exception applies only to the code released by OST under the
// name ACS.  If you copy code from other releases into a copy of
// ACS, as the General Public License permits, the exception does not
// apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
//
// If you write modifications of your own to ACS, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice, at which
// point the terms of your modification would be covered under the GPL
// as explicitly stated in "COPYING".

#include <config.h>
#include <debug.h>
#include <keydata.h>
#include <dso.h>
#include <stdio.h>

#ifdef	HAVE_MODULES

aDSO	*aDSO::latest = NULL;

aDSO::aDSO(char *filename)
{
	image = dlopen(filename, RTLD_NOW);
	if(!image)
		return;

	next = latest;
	latest = this;
}

aDSO::~aDSO()
{
	if(image)
	{
		dlclose(image);
		image = NULL;
	}
}

void load(void)
{
	aDSO *dso;
	char *cp;
	char *prefix;
	char lbuf[256];
	keydata_t *plugins = getkeydata("/umd/plugins");

	if(!plugins)
		return;

	prefix = getkeyfirst(plugins, "prefix");
	if(!prefix)
		prefix = "/opt/ACS/libexec/acs";

	cp = getkeyfirst(plugins, "modules");
	if(cp)
		cp = strtok(cp, " \t\n");

	while(cp)
	{
		sprintf(lbuf, "%s/%s.mod", prefix, cp);
		dso = new aDSO(lbuf);
		if(dso)
		{
			if(!dso->getImage())
			{
				syslog(LOG_WARNING, "%s: not loaded", cp);
				delete dso;
			}
			else
				syslog(LOG_INFO, "loading %s...", cp);
		}
		cp = strtok(NULL, " \t\n");
	}
	cp = getkeyfirst(plugins, "database");
	if(cp)
	{
		sprintf(lbuf, "%s/%s.dba", prefix, cp);
		dso = new aDSO(lbuf);
		if(dso)
		{
			if(!dso->getImage())
			{
				syslog(LOG_WARNING, "%s: not loaded", cp);
				delete dso;
			}
			else
				syslog(LOG_INFO, "dbi %s installed", cp);
		}
	}
	cp = getkeyfirst(plugins, "mailbox");
	if(cp)
	{
		sprintf(lbuf, "%s/%s.mbox", prefix, cp);
		dso = new aDSO(lbuf);
		if(dso)
		{
			if(!dso->getImage())
			{
				syslog(LOG_WARNING, "%s: not loaded", cp);
				delete dso;
			}
			else
				syslog(LOG_INFO, "mbi %s installed", cp);
		}
	}
	endkeydata(plugins);
}

int unload(void)
{
	aDSO *dso = aDSO::latest;
	aDSO *next;
	int count = 0;

	while(dso)
	{
		++count;
		next = dso->next;
		delete dso;
		dso = next;
	}
	if(count)
		syslog(LOG_INFO, "unloaded %d plugins", count);

	aDSO::latest = NULL;
	return count;
}

#endif
