// Copyright (C) 1999-2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, permission is
// granted for additional uses of the text contained in its release
// of ACS as noted here.
//
// This exception is that permission is hereby granted to link ACS with
// the Pika MonteCarlo static libraries to produce a executable image
// without requiring MonteCarlo itself to be supplied in source form so
// long as each source file so linked contains this exclusion.
//
// This exception does not however invalidate any other reasons why
// the resulting executable file might be covered by the GNU General
// public license or invalidate the licensing requirements of any
// other component or library.
//
// This exception applies only to the code released by OST under the
// name ACS.  If you copy code from other releases into a copy of
// ACS, as the General Public License permits, the exception does not
// apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
//
// If you write modifications of your own to ACS, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice, at which
// point the terms of your modification would be covered under the GPL
// as explicitly stated in "COPYING".

#ifndef	__MAILBOX_H__
#define	__MAILBOX_H__

class Mailbox;
class MBIModule;

class Mailbox
{
public:
	virtual ~Mailbox() = 0;

	virtual void setPassword(char *passwd) = 0;
	virtual char *getPassword(void) = 0;
	virtual void setOrder(char *order) = 0;
	virtual char *getTerm(void) = 0;
	virtual char *getUser(void) = 0;
	virtual char *getExtension(void) = 0;
	virtual char *getMailbox(void) = 0;
	virtual char *getNewCount(void) = 0;
	virtual char *getOldCount(void) = 0;
	virtual char *getSavedCount(void) = 0;
	virtual char *getRecordSize(void) = 0;
	virtual char *getMessage(void) = 0;
	virtual void setMessages(char *folder) = 0;
	virtual void NewMsgs(void) = 0;
	virtual void OldMsgs(void) = 0;
	virtual void SavedMsgs(void) = 0;
	virtual void Drop(void) = 0;
	virtual void Skip(char *mode) = 0;
	virtual void Save(void) = 0;
};

class MBIModule : public Module
{
private:
	keydata_t *dbkeys;

	char *scrExecute(Trunkmap *map)
		{return NULL;};

public:
	MBIModule();
	~MBIModule();

	keydata_t *getKeys(void)
		{return dbkeys;};

	char *getName(void)
		{return MODULE_DBI;};

	virtual char *Commit(Trunkmap *map) = 0;
	virtual char *Mailbox(Trunkmap *map) = 0;
	virtual char *Extension(Trunkmap *map) = 0;
	virtual char *Deliver(Trunkmap *map) = 0;
};

#endif
