// Copyright (C) 1999-2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, permission is
// granted for additional uses of the text contained in its release
// of ACS as noted here.
//
// This exception is that permission is hereby granted to link ACS with
// the Pika MonteCarlo static libraries to produce a executable image
// without requiring MonteCarlo itself to be supplied in source form so
// long as each source file so linked contains this exclusion.
//
// This exception does not however invalidate any other reasons why
// the resulting executable file might be covered by the GNU General
// public license or invalidate the licensing requirements of any
// other component or library.
//
// This exception applies only to the code released by OST under the
// name ACS.  If you copy code from other releases into a copy of
// ACS, as the General Public License permits, the exception does not
// apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
//
// If you write modifications of your own to ACS, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice, at which
// point the terms of your modification would be covered under the GPL
// as explicitly stated in "COPYING".

#include <config.h>
#include <scheduler.h>
#include <trunkmap.h>
#include <stdlib.h>

int Scheduler::Load(void)
{
	static char	*days[7] = {"su", "mo", "tu", "we", "th", "fr", "sa"}; 
	Trunkmap *map;
	time_t now;
	struct tm *dt;
	char	lbuf[129];
	char	*table, *day, *start, *cp;
	char	*p;
	int	hr, min;
	int	lhr = 24;
	int	lmin = 0;
	int	id;
	int	t1, t2, td;

	time(&now);
	dt = localtime(&now);
	fseek(fp, 0l, SEEK_SET);
	
	for(;;)
	{
		fgets(lbuf, sizeof(lbuf) - 1, fp);
		if(feof(fp))
			break;

		p = lbuf;
		while(*p == ' ' || *p == '\t' || *p == '\n')
			++p; 

		if(!*p || *p == '#' || *p == ';')
			continue;

		table = strtok(p, " \t\n");
		day = strtok(NULL, " \t\n");
		start = strtok(NULL, " \t\n");
		cp = strtok(NULL, " \t\n");
		if(!cp)
			continue;

		p = strtok(day, ",");
		while(p)
		{
			if(*p == '*')
				break;

			if(!strnicmp(p, days[dt->tm_wday], 2))
				break;
			p = strtok(NULL, ",;");
		}
		if(!p)
			continue;

		if(*start == '*')
		{
			hr = 0;
			min = 0;
		}
		else
		{
			hr = atoi(start);
			min = atoi(strchr(start, ':') + 1);
		}

		if(hr < lhr || (hr == lhr && min < lmin))
			if(hr > dt->tm_hour || (hr == dt->tm_hour && min > dt->tm_min))
			{
				lhr = hr;
				lmin = min;
			}

		if(hr > dt->tm_hour)
			continue;

		if(hr == dt->tm_hour && min > dt->tm_min)
			continue;

		if(*table == '*')
		{
			map = Trunkmap::firstmap;
			while(map)
			{
				map->setSchedule(SCHED_DAILY, cp);
				map = map->nextmap;
			}
			continue;
		}
		p = strtok(table, ",;");
		while(p)
		{
			id = atoi(p);
			p = strtok(NULL, ",;");
			map = Trunkmap::firstmap;
			while(id-- && map)
				map = map->nextmap;

			if(!map)
				continue;

			map->setSchedule(SCHED_DAILY, cp);
		}
	}
	td = (lhr * 60) + lmin - (dt->tm_hour * 60) - dt->tm_min;
	if(td > 15)
		td = 15;
	if(td < 1)
		td = 1;
	return td;	
}

Scheduler::Scheduler(char *path, int pri) : 
Thread(NULL, pri), Mutex()
{
	strcpy(schedpath, path);
	interval = 0;
};

Scheduler::~Scheduler(void)
{
	Terminate();
	if(fp)
		fclose(fp);
}

void Scheduler::Initial(void)
{
	fp = fopen(schedpath, "r");

	setCancel(THREAD_CANCEL_DEFERRED);
}

void Scheduler::Run(void)
{
	for(;;)
	{
		if(!fp)
			Initial();

		if(fp && interval < 1)
		{
			ENTER_CRITICAL
			interval = Load();
			LEAVE_CRITICAL
		}
		else
			--interval;

		sleep(60);		
	}
}


