// Copyright (C) 1999-2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, permission is
// granted for additional uses of the text contained in its release
// of ACS as noted here.
//
// This exception is that permission is hereby granted to link ACS with
// the Pika MonteCarlo static libraries to produce a executable image
// without requiring MonteCarlo itself to be supplied in source form so
// long as each source file so linked contains this exclusion.
//
// This exception does not however invalidate any other reasons why
// the resulting executable file might be covered by the GNU General
// public license or invalidate the licensing requirements of any
// other component or library.
//
// This exception applies only to the code released by OST under the
// name ACS.  If you copy code from other releases into a copy of
// ACS, as the General Public License permits, the exception does not
// apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
//
// If you write modifications of your own to ACS, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice, at which
// point the terms of your modification would be covered under the GPL
// as explicitly stated in "COPYING".

#include <sys/stat.h>
#include <config.h>
#include <trunkmap.h>
#include <debug.h>
#include <dirent.h>
#include <keydata.h>
#include <unistd.h>
#include <dirent.h>
#include <misc.h>

int	_debug = 0;

char	Script::dtmfkeys[] = "0123456789*#ABCD";
Script	*Script::current = NULL;
int	Script::count;

Script::Script(char *aapath, keydata_t *keyscript) :
Mutex(), Mempager(4096)
{
	Script *script = current;
	int cnt = 0;
	int lines;
	DIR *aadir = opendir(aapath);
	struct dirent *dir;
	char *cp;
	char path[128];
	struct stat ino;

	if(!aadir)
	{
		throw(this);
		return;
	}
	
	id = ++count;
	remove = false;
	links = 0;
	current = this;

	for(cnt = 0; cnt < SCR_INDEX_SIZE; ++cnt)
		keys[cnt] = NULL;

	while(NULL != (dir = readdir(aadir)))
	{
		cp = strrchr(dir->d_name, '.');
		if(cp)
		{
			if(strcmp(cp, ".scr"))
				continue;
		}
		else
			continue;

		if(dir->d_name[0] == '.')
			continue;

		strcpy(path, aapath);
		strcat(path, "/");
		strcat(path, dir->d_name);
		stat(path, &ino);
		if(S_ISREG(ino.st_mode))
		{
			lines = Compile(path, keyscript);					
			debug(3, "compiling %s; %d lines", dir->d_name, lines);
		}
	}
	closedir(aadir);

	debug(2, "interp %d compiled; loaded %d pages", id, getPages());

	// attempt unload of prior script / mark for later delete

	if(script)
	{
		script->EnterMutex();
		script->remove = true;
		cnt = script->links;
		script->LeaveMutex();
		if(!cnt)
			delete script;
	}
}

Script::~Script()
{
	debug(2, "interp %d removed; unloaded %d pages", id, getPages());
}

unsigned Script::keyindex(char *str)
{
	unsigned key = 0;

	while(*str)
	{
		key = (key << 1) ^ (*str & 0x1f);
		++str;
	}
	return key % SCR_INDEX_SIZE;
}

Menu *lookup(Script *scr, char *name)
{
	unsigned key = scr->keyindex(name);
	Menu *menu = scr->keys[key];

	while(menu)
	{
		if(!stricmp(menu->name, name))
			return menu;

		menu = menu->next;
	}
	
	return NULL;
}

void detach(Script *scr)
{
	int	cnt;
	scr->EnterMutex();
	cnt = --scr->links;
	scr->LeaveMutex();
	if(!cnt && remove && Script::current != scr)
		delete scr;
}

Script *attach(void)
{
	Script *scr = Script::current;
	scr->EnterMutex();
	++scr->links;
	scr->LeaveMutex();
	return scr;
}

void endScript(void)
{
	if(Script::current)
		delete Script::current;

	Script::current = NULL;
}

	
