// Copyright (C) 1999-2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, permission is
// granted for additional uses of the text contained in its release
// of ACS as noted here.
//
// This exception is that permission is hereby granted to link ACS with
// the Pika MonteCarlo static libraries to produce a executable image
// without requiring MonteCarlo itself to be supplied in source form so
// long as each source file so linked contains this exclusion.
//
// This exception does not however invalidate any other reasons why
// the resulting executable file might be covered by the GNU General
// public license or invalidate the licensing requirements of any
// other component or library.
//
// This exception applies only to the code released by OST under the
// name ACS.  If you copy code from other releases into a copy of
// ACS, as the General Public License permits, the exception does not
// apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
//
// If you write modifications of your own to ACS, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice, at which
// point the terms of your modification would be covered under the GPL
// as explicitly stated in "COPYING".

#ifndef	__SCRIPT_H__
#define	__SCRIPT_H__

#ifndef	__KEYDATA_H__
#include <keydata.h>
#endif

#ifndef	__MISC_H__
#include <misc.h>
#endif

#define	SCR_INDEX_SIZE	71

class Trunkmap;
class Module;

typedef void (Trunkmap::*script_t)(void);

typedef	struct _cmd
{
	unsigned long mask;	// digit trap mask?
	int	line;		// line number
	struct	_cmd *next;	// next script - first if last line
				// of a 'segment'!!!!
	char	*cmd;		// command executed
	char	**argv;		// greeting strings/options
	script_t scrHandler;	// handler
	Module	*module;
} Command;

// Menu "head" or overlay of script based on ^ entries in script

typedef	struct	_menu
{
	struct	_menu *next;
	char	*name;
	unsigned long mask;	// digit trap mask
	Command	*first;		// first script line
	Command	*D[16];		// digit intercepts
	Command *TO;		// timeout intercept
	Command *ERR;		// error intercept
	Command *TRAP;		// disconnect trap
	Command *L[10];		// local symbols
}	Menu;

class	Script : public Mutex, public Mempager
{
private:
	static char dtmfkeys[];
	static Script	*current;
	static int count;
	bool remove;
	int links;
	int id;
	Menu *keys[SCR_INDEX_SIZE];

	unsigned keyindex(char *name);
	int getdigit(char digit);
	int Compile(char *path, keydata_t *keyscript);

public:
	Script(char *aapath, keydata_t *keyscript);
	~Script();

	friend Menu *lookup(Script *scr, char *name);
	friend Script *attach(void);
	friend void detach(Script *);

	friend void endScript(void);
};

#endif

