// Copyright (C) 1999-2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, permission is
// granted for additional uses of the text contained in its release
// of ACS as noted here.
//
// This exception is that permission is hereby granted to link ACS with
// the Pika MonteCarlo static libraries to produce a executable image
// without requiring MonteCarlo itself to be supplied in source form so
// long as each source file so linked contains this exclusion.
//
// This exception does not however invalidate any other reasons why
// the resulting executable file might be covered by the GNU General
// public license or invalidate the licensing requirements of any
// other component or library.
//
// This exception applies only to the code released by OST under the
// name ACS.  If you copy code from other releases into a copy of
// ACS, as the General Public License permits, the exception does not
// apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
//
// If you write modifications of your own to ACS, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice, at which
// point the terms of your modification would be covered under the GPL
// as explicitly stated in "COPYING".

#include <config.h>
#include <keydata.h>
#include <debug.h>
#include <stdlib.h>
#include <signal.h>
#include <fcntl.h>
#include <sys/wait.h>
#include <cc++/thread.h>
#include <cc++/file.h>
#include "shell.h"

Shell *Shell::shell = NULL;

Shell::Shell(char *ctrlfile, int uid, int pool) :
Pipe()
{
	int argc;
	int vpid;
	int stat;
	int cfd;
	char env[512];
	char *argv[16];
	sigset_t sigs;

	shell = this;
	ctrl = ctrlfile;
	count = pool;
	pid = new int[pool];

	for(pool = 0; pool < count; ++pool)
	{
		pid[pool] = fork();
		if(!pid[pool])
			break;
	}
	
	if(pool == count)
	{
		Sender();
		return;
	}

	endkeydata(NULL);
	Receiver();

	cfd = open(shell->ctrl, O_RDWR);
	while(cfd < 3)
		cfd = dup(cfd);

	//setuid(uid);
	sigemptyset(&sigs);
	sigaddset(&sigs, SIGINT);
	signal(SIGINT, &Signal);
	sigprocmask(SIG_UNBLOCK, &sigs, NULL);
	debug(9, "libexec = %s", getenv("SERVER_LIBEXEC"));
	sleep(3);

	while(Read(&cmd, sizeof(cmd)) == sizeof(cmd))
	{
		argc = 0;
		debug(2, "execute %s", cmd.cmd);

		vpid = vfork();
		if(vpid)
		{
			sprintf(env, "wait %d %d\n", cmd.port, vpid);
			write(cfd, env, strlen(env));

			waitpid(vpid, &stat, 0);
			if(!cmd.port)
				continue;

			sprintf(env, "exit %d %d\n", cmd.port, WEXITSTATUS(stat));
			write(cfd, env, strlen(env));
			continue;
		}

		sprintf(env, "%d", cmd.port);
		setenv("PORT_NUMBER", env, 1);
		argv[argc++] = strtok(cmd.cmd, " \t");
		while(NULL != (argv[argc] = strtok(NULL, " \t")))
		{
			if(!strnicmp(argv[argc], "digits=", 7))
			{
				setenv("PORT_DIGITS", argv[argc] + 7, 1);
				continue;
			}

			if(!strnicmp(argv[argc], "cid=", 4))
			{
				setenv("PORT_CID", argv[argc] + 4, 1);
				continue;
			}

			if(!strnicmp(argv[argc], "ani=", 4))
			{
				setenv("PORT_ANI", argv[argc] + 4, 1);
				continue;
			}

			if(!strnicmp(argv[argc], "dnid=", 5))
			{
				setenv("PORT_DNID", argv[argc] + 5, 1);
				continue;
			}

			if(!strnicmp(argv[argc], "query=", 6))
			{
				setenv("PORT_QUERY", argv[argc] + 6, 1);
				continue;
			}
			++argc;
		}
		argv[argc] = NULL;

		closelog();
		Sender();
		close(0);
		close(1);
		close(2);
		open("/dev/null", O_RDWR);
		if(cmd.port)
			dup2(cfd, 1);
		else
			dup2(0, 1);
		dup2(0, 2);
		close(cfd);

		if(strncmp(*argv, "root-", 5))
			setuid(uid);

		setenv("PATH", getenv("SERVER_LIBEXEC"), 1);
		sprintf(env, "%s/%s", getenv("SERVER_LIBEXEC"), *argv);
		execvp(env, argv);
		syslog(LOG_DAEMON | LOG_ERR, "exec failed; %s", env);
		exit(-1);
	}
	Signal(SIGINT);
}		

Shell::~Shell()
{
	int pool;

	for(pool = 0; pool < count; ++pool)
	{
		if(pid[pool])
		{
			kill(pid[pool], SIGINT);
			waitpid(pid[pool], &pid[pool], 0);
		}
	}
	delete pid;
}
	
RETSIGTYPE Shell::Signal(int signo)
{
	int pid;
	int i;
	int stat;
	char buf[33];
	int fd;

	switch(signo)
	{
	case SIGTERM:
	case SIGINT:
		exit(0);
	}
}	

void execute(int trunk, char *str)
{
	Shell::shell->cmd.port = trunk;
	strncpy(Shell::shell->cmd.cmd, str, SHELL_COMMAND_SIZE - 1);
	Shell::shell->cmd.cmd[SHELL_COMMAND_SIZE - 1] = 0;
	Shell::shell->Write(&Shell::shell->cmd, sizeof(Shell::shell->cmd));
}

