// Copyright (C) 1999-2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, permission is
// granted for additional uses of the text contained in its release
// of ACS as noted here.
//
// This exception is that permission is hereby granted to link ACS with
// the Pika MonteCarlo static libraries to produce a executable image
// without requiring MonteCarlo itself to be supplied in source form so
// long as each source file so linked contains this exclusion.
//
// This exception does not however invalidate any other reasons why
// the resulting executable file might be covered by the GNU General
// public license or invalidate the licensing requirements of any
// other component or library.
//
// This exception applies only to the code released by OST under the
// name ACS.  If you copy code from other releases into a copy of
// ACS, as the General Public License permits, the exception does not
// apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
//
// If you write modifications of your own to ACS, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice, at which
// point the terms of your modification would be covered under the GPL
// as explicitly stated in "COPYING".

#ifndef	__TRUNKMAP_H__
#define	__TRUNKMAP_H__

#include <runmap.h>
#include <scheduler.h>
#include <script.h>
#include <module.h>
#include <mailbox.h>

#define	WORD_SPELL	0x0001
#define	WORD_DATE	0x0002
#define WORD_ORDER	0x0004

#define	MAX_STACK	10
#define	TIMEOUT_MASK	0x10000
#define	ERROR_MASK	0x20000

enum
{
	NUMBER_NORMAL,
	NUMBER_ORDER
};

class Vocab;

class Trunkmap
{
private:
	static char dtmfkeys[];
	static Trunkmap *firstmap, *lastmap;
	static int active;
	Trunkmap *nextmap;
	Runmap *runmap;
//	Trunkmap **portmap;
	Script *script;
	Menu *menu;
	Command *cmd[MAX_STACK];
	bool listflag;
	int stack;
	int sched;
	int argc;
	int transaction;
	int temps;
	int item;
	char lang[16];
	char temp[4][33];
	char vars[10][33];
	char *wordlist[33];
	char wordbuffer[65];
	int wordcount;
	int wordlast;
	unsigned wordmask;
	unsigned volume;
	
	void setSchedule(int sc, char *scr);
	void clrSchedule(void)
		{sched = SCHED_RESET;};

//	friend class Portmap;
	friend class Scheduler;
	friend class Script;

	void scrTrace(void);
	void scrErrorStep(char *errorstr);
	void sayNumber(long nbr, int style);

protected:
	Vocab *vocab;
	Mailbox *mailbox;
	long offset;
	time_t starttime;
	time_t ringtime;
	time_t idletime;
	bool trap;
	bool expired;
	bool offhook;
	bool keywait;
	bool dtmf;
	bool idle;
	long timer;
	int rings;
	int ring_count;
	int ring_timer;
	char cid[256];
	char ani[17];
	char dnid[17];
	char digit[33];
	char term[17];
	char ignore[17];
	int digits, collect;
	char error[17];
	int exstatus;
	int waitpid;
	int id;

	void setcid(void);
	bool exeTrap(void);
	void newWord(void);
	char *getWord(void);
	void sayWord(char *word);
	void setPid(int pid);
	void setCurrent(char *str);
	void scrAttach(char *scr);
	void scrDetach(void);
	void scrExecute(void);
	void scrNext(void);
	void scrLog(void);
	void scrExists(void);
	void scrAdd(void);
	void scrTrim(void);
	void scrCall(void);
	void scrGoto(void);
	void scrTrap(void);
	void scrReturn(void);
	void scrErase(void);
	void scrLink(void);
	void scrMove(void);
	void scrPop(void);
	void scrIf(void);
	void scrPrefix(void);
	void scrSelect(void);
	void scrTimeout(void);
	void scrError(char *err);
	void scrDigit(int trap);
	void scrClear(void);
	void scrFirstItem(void);
	void scrLastItem(void);
	void scrNextItem(void);
	void scrPrevItem(void);
	void scrList(void);
	void scrSet(void);
	void scrInit(void);
	void scrDefine(void);
	void scrLibexec(void);
	void scrTGI(bool wait, bool detach);
	void scrMessages(void);
	void scrSkip(void);
	void scrDrop(void);
	void scrSave(void);
	void scrInsert(void);
	void scrDelete(void);
	void scrUpdate(void);
	void scrSearch(void);
	void scrMailbox(void);
	void scrExtension(void);
	void scrCommit(void);
	void scrDeliver(void);

	virtual void scrFlash(void) = 0;
	virtual void scrModule(void) = 0;
	virtual void scrStop(void) = 0;
	virtual void scrHangup(void) = 0;
	virtual void scrAnswer(void) = 0;
	virtual void scrWait(void) = 0;
	virtual void scrSleep(void) = 0;
	virtual void scrBusyout(void) = 0;
	virtual void scrSay(void) = 0;
	virtual void scrPlay(void) = 0;
	virtual void scrRecord(void) = 0;
	virtual void scrCollect(void) = 0;
	virtual void scrDial(void) = 0;
	virtual void scrExWait(void) = 0;
	virtual void scrStep(void)
		{scrNext();};

	virtual void setDTMF(void) = 0;
	virtual void endDTMF(void) = 0;

	virtual char *getExtension(void)
		{return ".ul";};

	inline char *getSchedule(char *buf)
		{return strcpy(buf, runmap->schedule);};

	inline char *getCurrent(char *buf)
		{return strcpy(buf, runmap->current);};

	inline Module *getModule(void)
		{return cmd[stack]->module;};

public:
	Trunkmap(Runmap *map, char *script = NULL);
	virtual ~Trunkmap();

	char *getOption(char *defoption);
	void setVariable(char *sym, char *value);
	char *getVariable(char *sym);
	time_t getIdleTime(void);

	virtual void exitModule(char *errmsg, int id) = 0;

	inline char *getLanguage(void)
		{return lang;};

	inline int getTransaction(void)
		{return transaction;};

	inline int getNextTransaction(void)
		{return ++transaction;};
	
	inline int getRecordVolume(void)
		{return (volume & 0xff00) / 256;};

	inline int getPlayVolume(void)
		{return (volume & 0x00ff);};

	inline int getNumber(void)
		{return id;};

	friend class Sessionmap;

	friend int getActiveTrunks(void)
		{return active;};
};

#endif
