// Copyright (C) 1999-2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, permission is
// granted for additional uses of the text contained in its release
// of ACS as noted here.
//
// This exception is that permission is hereby granted to link ACS with
// the Pika MonteCarlo static libraries to produce a executable image
// without requiring MonteCarlo itself to be supplied in source form so
// long as each source file so linked contains this exclusion.
//
// This exception does not however invalidate any other reasons why
// the resulting executable file might be covered by the GNU General
// public license or invalidate the licensing requirements of any
// other component or library.
//
// This exception applies only to the code released by OST under the
// name ACS.  If you copy code from other releases into a copy of
// ACS, as the General Public License permits, the exception does not
// apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
//
// If you write modifications of your own to ACS, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice, at which
// point the terms of your modification would be covered under the GPL
// as explicitly stated in "COPYING".

#include <cc++/config.h>
#include <cc++/file.h>
#include <sys/stat.h>
#include <debug.h>
#include <unistd.h>
#include <stdlib.h>
#include <misc.h>
#include <keydata.h>
#include <aufile.h>
#include "vocab.h"

Vocab	*Vocab::first = NULL;

Vocab::Vocab(char *path) :
Mempager(4096)
{
	FILE *fp;
	WORD *word, *prior = NULL;
	char *text;
	int key;
	struct stat ino;
	char filename[256];
	char *cp = strrchr(path, '/');
	memset(name, 0, sizeof(name));
	format = AU_ENCODING_MULAW;
	sampling = AU_SAMPLING_8khz;

	if(cp)
		strncpy(name, ++cp, sizeof(name) - 1);
	else
		strncpy(name, path, sizeof(name) - 1);

	strcpy(filename, path);
	strcat(filename, "/words.data");
	if(stat(filename, &ino))
	{
		debug(1, "%s: data file missing", name);
		throw(this);
		return;
	}

	map = new MappedFile(filename, (pos_t)0l, ino.st_size, FILE_MAPPED_READ);
	if(!map)
	{
		debug(1, "%s: data mapping failed", name);
		throw(this);
		return;
	}
	base = (unsigned char *)(map->Fetch(0));

	strcpy(filename, path);
	strcat(filename, "/words.index");
	fp = fopen(filename, "r");
	if(!fp)
	{
		debug(1, "%s: index missing", name);
		throw(this);
		return;
	}

	for(;;)
	{
		fgets(filename, sizeof(filename) - 1, fp);
		if(feof(fp))
			break;
		text = strtok(filename, " \t\n");
		cp = strtok(NULL, " \t\n");
		if(!cp)
			continue;

		word = (WORD *)alloc(sizeof(WORD) + strlen(text) + 1);
		if(!word)
			break;

		strcpy(word->text, text);
		word->start = base + atol(cp);
		key = keyindex(text);
		word->link = words[key];
		words[key] = word;		
		if(prior)
		{
			prior->size = (unsigned long)(word->start - prior->start);
			debug(9, "word %s %p %ld loaded", prior->text, prior->start, prior->size);
		}
		prior = word;
	}

	if(prior)
	{
		prior->size = (unsigned long)(ino.st_size - (prior->start - base));
		debug(9, "word %s %p %ld loaded", prior->text, prior->start, prior->size);
	}

	fclose(fp);	
	next = first;
	first = this;
	debug(2, "vocab %s: loaded %d pages", name, getPages());
}

Vocab::~Vocab()
{
	if(map)
		delete map;

	debug(2, "vocab %s removed; unloaded %d pages", name, getPages());
}

unsigned Vocab::keyindex(char *str)
{
	unsigned key = 0;

	while(*str)
	{
		key = (key << 1) ^ (*str & 0x1f);
		++str;
	}
	return key % VOCAB_INDEX_SIZE;
}

WORD *Vocab::getWord(char *text)
{
	unsigned key = keyindex(text);
	WORD *word = words[key];

	while(word)
	{
		if(!stricmp(word->text, text))
			return word;
		word = word->link;
	}
	return NULL;
} 

Vocab *getVocabulary(char *lang)
{
	Vocab *vocab = Vocab::first;

	while(vocab)
	{
		if(!stricmp(vocab->name, lang))
			return vocab;
		vocab = vocab->next;
	}
	return NULL;
}

void unloadVocab(void)
{
	Vocab *vocab = Vocab::first;
	Vocab *next;

	while(vocab)
	{
		next = vocab->next;
		delete vocab;
		vocab = next;
	}
	Vocab::first = NULL;
}

void loadVocab(keydata_t *keypaths)
{
	struct stat ino;
	char pathname[256];
	char *prefix = getkeylast(keypaths, "prompts");
	char *lang = getkeylast(keypaths, "languages");
	if(!lang)
		lang = getkeylast(keypaths, "voices");

	if(!prefix || !lang)
		return;

	lang = strtok(lang, " :\t");
	while(lang)
	{
		sprintf(pathname, "%s/%s", prefix, lang);
		lang = strtok(NULL, " :\t");
		if(stat(pathname, &ino))
			continue;

		new Vocab(pathname);
	}
}
			
