/*
** Copyright (C) 1999-2000 Open Source Telecom Corporation.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <cc++/config.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <fcntl.h>
#include <keydata.h>
#include <runmap.h>

int main(int argc, char **argv)
{
	keydata_t *keypaths = getkeydata("/umd/paths");
	char	*runfile = NULL;
	Runmap	map;
	int	fd;
	int	port = 1;
	int	len;

	if(keypaths)
		runfile = getkeyfirst(keypaths, "runfile");

	if(!runfile)
		runfile = "/var/run/umd";

	if(argc != 1)
	{
		fprintf(stderr, "usage: umdstat\n");
		exit(-1);
	}	

	printf("runfile %s\n", runfile);
	fd = open(runfile, O_RDONLY);
	if(fd < 0)
		exit(-1);

	for(;;)
	{
		len = read(fd, &map, sizeof(map));
		if(len < sizeof(map))
			exit(0);

		printf("%02d %s %s\n", port++, map.current, map.schedule);
	}
}

