/*
** Copyright (C) 1999-2000 Open Source Telecom Corporation.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <cc++/config.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <fcntl.h>
#include <keydata.h>
#include <sys/stat.h>

int main(int argc, char **argv)
{
	keydata_t *keypaths = getkeydata("/umd/paths");
	char	*ctrlfile = NULL;
	int	fd;
	struct stat ino;

	if(keypaths)
		ctrlfile = getkeyfirst(keypaths, "ctrlfile");

	if(!ctrlfile)
		ctrlfile = "/var/run/umdctrl";

	if(argc != 1)
	{
		fprintf(stderr, "usage: umdstop\n");
		exit(-1);
	}	

	fd = open(ctrlfile, O_WRONLY);
	if(fd < 0)
		exit(-1);

	write(fd, "down\n", 5);
	close(fd);
	while(!stat(ctrlfile, &ino))
		sleep(2);		
}

