// Copyright (C) 1999-2000 Open Source Telecom Corporation
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include <config.h>
#include <syslog.h>
#include "server.h"
#include "trunk.h"
#include "vpbapi.h"

void Trunk::Answer(EventRecord *er)
{
	int rtn;

	switch(er->event)
	{
	case UM_EVENT_ENTER_STATE:
		if(offhook)
			break;

		ring_count = atoi(getOption("0"));
		ring_timer = atoi(getOption("6"));

	case UM_EVENT_RING_LINE:
		rings = 0;
	case VPB_RING:
		if(!rings || rings >= ring_count)
		{
			endTimer();
			vpb_sethook_sync(hTrk, VPB_OFFHOOK);
			time(&starttime);
			offhook = true;
			break;
		}
		++rings;
		setTimer(ring_timer * 1000);
		setDTMF();		
		return;
	case VPB_TIMEREXP:
		endTimer();
		setHandler((handler_t)&Trunk::Idle);
		return;
	default:
		Default(er);
		return;
	}
	scrNext();
}
