// Copyright (C) 1999-2000 Open Source Telecom Corporation
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include <config.h>
#include <debug.h>
#include "server.h"
#include "trunk.h"

void Trunk::Busy(EventRecord *er)
{
	int	rtn;

	switch(er->event)
	{
#ifdef MODIFY_LATER
	case PK_EVENT_TIMER_EXPIRED:
#endif
	case UM_EVENT_ENTER_STATE:
		endTimer();
		endDTMF();
		scrDetach();
		trap = false;
#ifdef MODIFY_LATER
		rtn = PK_TRUNK_OffHook(hTrk);
		if(rtn != PK_TRUNK_E_NOT_ONHOOK)
			PK_TRUNK_OnHook(hTrk);
#endif
		break;
#ifdef MODIFY_LATER
	case PK_EVENT_TRUNK_OFFHOOK:
		setCurrent("BUSY");
		debug(1, "trunk %02d made busy", id);
		break;
	case PK_EVENT_TRUNK_ONHOOK:
		setTimer(5000);
		break;
#endif
	case UM_EVENT_MAKE_BUSY:
		break;
	case UM_EVENT_MAKE_IDLE:
		debug(1, "trunk %02d restoring...", id);
	default:
		Default(er);
	}
}
