// Copyright (C) 1999-2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include <assert.h>
#include <config.h>
#include "server.h"
#include "trunk.h"
#include "session.h"

#define	PORT_CAPACITY	4

static int port_count = 0;
static MappedFile *runfile = NULL;
static Session *session;
//Trunk **trunks = NULL;

int getDriverPorts(void)
{
	return port_count;
}

int initDriver(char *scr, int ports)
{
	int count = 0;
	int trunk = 0;

	// set up run maps

	File rundata(getkeyfirst(keypaths, "runfile"), FILE_OPEN_TRUNCATE, 0640);
	Runmap runmap, *map;
	memset(&runmap, 0, sizeof(runmap));
	strcpy(runmap.current, "INITIALIZING...");
	strcpy(runmap.schedule, "default");

	if(!ports)
		ports = PORT_CAPACITY;

	if(ports > PORT_CAPACITY)
		ports = PORT_CAPACITY;

	port_count = ports;

	count = ports;
	for(trunk = count; trunk > 0; --trunk)
		write(rundata, &runmap, sizeof(runmap));

	runfile = new MappedFile(getkeyfirst(keypaths, "runfile"), 0, sizeof(runmap) * count, FILE_MAPPED_RDWR);
 
	if(!runfile)
	{
		throw(count);
		return -1;
	}

	// set up trunks

	session = (Session *)new Session(count);
//	trunks = (Trunk **)new Trunk *[count];
	assert(Session::trunks != NULL);
	for(trunk = 0; trunk < count; ++trunk)
	{
 		map = (Runmap *)runfile->Fetch(trunk * sizeof(runmap));
		Session::trunks[trunk] = new Trunk(map, scr);
		assert(Session::trunks[trunk] != NULL);
	}
	return 0;
}

int stopDriver(void)
{
	int trunk = 0;

	// delete turnks
	while(Session::trunks && trunk < port_count)
		delete Session::trunks[trunk++];

//	if(trunks)
//		delete[] trunks;

	if(session)
		delete session;

	return 0;
}

