// Copyright (C) 1999-2000 Open Source Telecom Corporation
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include <config.h>
#include <syslog.h>
#include <stdlib.h>
#include "server.h"
#include "trunk.h"
#include "vpbapi.h"

void Trunk::FlashOff(EventRecord *er)
{
	switch(er->event)
	{
	case UM_EVENT_ENTER_STATE:
		vpb_sethook_sync(hTrk, VPB_OFFHOOK);
		setTimer(atol(getOption("100")));
		return;
	case VPB_TIMEREXP:
		endTimer();
		break;
	default:
		Default(er);
		return;
	}
	scrNext();
}
		
void Trunk::FlashOn(EventRecord *er)
{
	switch(er->event)
	{
	case UM_EVENT_ENTER_STATE:
		if(!offhook)
			break;

		vpb_sethook_sync(hTrk, VPB_ONHOOK);
		setTimer(atol(getOption("100")));
		return;
	case VPB_TIMEREXP:
		endTimer();
		setHandler(&Trunk::FlashOff);
		return;
	default:
		Default(er);
		return;
	}
	scrNext();
}
