// Copyright (C) 1999-2000 Open Source Telecom Corporation
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include <config.h>
#include <debug.h>
#include "server.h"
#include "trunk.h"
#include "vpbapi.h"

void Trunk::Idle(EventRecord *er)
{
	int	rtn;
	
	switch(er->event)
	{
	case UM_EVENT_ENTER_STATE:
	        debug(2, "Idle: enter state");
		cid[0] = 0;
		ani[0] = 0;
		dnid[0] = 0;

		endTimer();
		endDTMF();
		vpb_sethook_sync(hTrk, VPB_ONHOOK);
		offhook = false;
		idle = true;
		trap = false;
		rings = 0;
		if(mailbox)
		{
			delete mailbox;
			mailbox = NULL;
		}
		if(waitpid)
		{
			kill(waitpid, SIGHUP);
			waitpid = 0;
		}
		time(&idletime);
		setCurrent("IDLE");
		scrDetach();
		break;
	
	case UM_EVENT_START_LINE:
		time(&ringtime);
		setcid();
		idle = offhook = false;
		scrAttach((char *)er->p2);
		break;

	case VPB_RING:
		++rings;
	case UM_EVENT_RING_LINE:
		time(&ringtime);
		setcid();
	        debug(2, "Idle: RING");
		idle = offhook = false;
		scrAttach(NULL);
		break;

	case UM_EVENT_MAKE_IDLE:
		break;

	default:
		Default(er);
	}
}



