// Copyright (C) 1999-2000 Open Source Telecom Corporation
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include <config.h>
#include <syslog.h>
#include <stdlib.h>
#include <trunkmap.h>
#include <module.h>
#include "trunk.h"
#include "vpbapi.h"

void Trunk::Module(EventRecord *er)
{
#ifdef	HAVE_MODULES
	class Module *module;
	int timer;
	char *arg;
	char *err;
	switch(er->event)
	{
	case UM_EVENT_EXIT_MODULE:
		if(er->p2 != getTransaction())
			return;

		endTimer();
		if(er->p1)
			return scrError((char *)er->p1);
		break;
	case UM_EVENT_ENTER_STATE:
		module = getModule();
		if(!module)
			break;

		err = module->scrExecute((Trunkmap *)this);
		if(err)
			return scrError(err);

		timer = module->getTimeout() * 1000;
		if(!timer)
			return scrStep();

		setTimer(timer * 1000);
		return;
	case VPB_TIMEREXP:
		endTimer();
		return scrTimeout();
	default:
		Default(er);
		return;
	}
	scrNext();
#endif
}
