// Copyright (C) 1999-2000 Open Source Telecom Corporation
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include <config.h>
#include <syslog.h>
#include "server.h"
#include "trunk.h"
#include "vpbapi.h"

void Trunk::StopPlay(EventRecord *er)
{
        //debug(2, "StopPlay\n");

	switch(er->event)
	{
	case UM_EVENT_ENTER_STATE:
	        vpb_play_terminate(hTrk);
	        break;
	case UM_EVENT_STOP_STATE:
		return;
	default:
		Default(er);
		return;
	}
	scrExecute();
}

void Trunk::Play(EventRecord *er)
{
	int rtn;
	char *ext;
	char *fn, *cp;
	char pathname[128];
	
	switch(er->event)
	{
	case UM_EVENT_STOP_STATE:
		setHandler(&Trunk::StopPlay);
		return;
	
	case UM_EVENT_ENTER_STATE:
	  //debug(1,"play:enter state");

	        vpb_enable_event(hTrk, VPB_MDTMF);
		if(!offhook)
		{
		        vpb_sethook_sync(hTrk, VPB_OFFHOOK);
			//time(&starttime);
			offhook = true;
		}
		setDTMF();

		// set up file name

	case VPB_PLAYEND:
		fn = getOption(NULL);
		if(!fn)
			break;
		if (strchr(fn, '/'))
			pathname[0] = 0;
		else
		{
		  	strcpy(pathname, getkeylast(keypaths, "prompts"));
		  	strcat(pathname, "/");
			if(!strnicmp(fn, "*:", 2))
			{
				strcat(pathname, getLanguage());
				++fn;
			}
		}
		strcat(pathname, fn);
		cp = strchr(pathname, ':');
		if(cp)
			*cp = '/';

		cp = strrchr(pathname, '/');
		cp = strrchr(cp, '.');
		if(!cp)		
			strcat(pathname,".wav");
		debug(2, "pathname = %s\n",pathname);

		vpb_play_file_async(hTrk, pathname, 0);
		return;
//	case VPB_DTMF:
//	        //debug(2,"DTMF in play");
//	        Default(er);
//	        return;
	default:
		Default(er);
		return;
	}
	//vpb_disable_event(hTrk, VPB_MDTMF);
	scrNext();
}

