// Copyright (C) 1999-2000 Open Source Telecom Corporation
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include <config.h>
#include <syslog.h>
#include <stdlib.h>
#include "server.h"
#include "trunk.h"
#include "vpbapi.h"

void Trunk::Record(EventRecord *er)
{
	int rtn;
	char *fn;
	
	//debug(2,"record\n");
	switch(er->event)
	{
	case VPB_TIMEREXP:
		return scrTimeout();
	case UM_EVENT_STOP_STATE:
		endTimer();
		return scrExecute();

	case UM_EVENT_ENTER_STATE:
		expired = false;
		keywait = false;
		if(!offhook)
		{
		        vpb_sethook_sync(hTrk, VPB_OFFHOOK);
			time(&starttime);
			offhook = true;
		}

		setDTMF();
		vpb_enable_event(hTrk, VPB_MDTMF);
		fn = getOption(NULL);
		if(!fn)
			break;
		setTimer(atoi(getOption(getkeyfirst(keyaudio, "timer"))) * 1000);
		strncpy(term, getOption(""), 16);
		term[16] = 0;

		// set up file name

		char pathname[128];
		if (strchr(fn, '/'))
			pathname[0] = 0;
		else 
		{
			strcpy(pathname, getkeylast(keypaths, "prompts"));
		  	strcat(pathname, "/");
		}
		
		strcat(pathname, fn);
		strcat(pathname,".wav");
		//debug(2, "pathname = %s\n",pathname);
		vpb_record_file_async(hTrk, pathname, VPB_MULAW);
		return;

	case VPB_DTMF:
		keywait = true;
		if(strchr(term, (char)er->p1))
		{
			endTimer();
			vpb_record_terminate(hTrk);
			break;
		}	
	default:
		Default(er);
		return;
	}

	vpb_disable_event(hTrk, VPB_MDTMF);
	scrNext();
}










