// Copyright (C) 1999-2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include <config.h>
#include "server.h"
#include "trunk.h"
#include "session.h"

Trunk **Session::trunks = NULL;

Session::Session(int count) : Sessionmap()
{
	trunks = (Trunk **)new Trunk *[count];
}

Session::~Session() 
{
	delete[] trunks;
}

void Session::setBusy(int id)
{
	EventRecord er;
	Trunk *trunk = getVpbTrunk(id);

	if(!trunk)
		return;

	er.event = UM_EVENT_MAKE_BUSY;
	er.p1 = er.p2 = 0;
	SendMessage(trunk, &er);
}

void Session::setIdle(int id)
{
	EventRecord er;
	Trunk *trunk = getVpbTrunk(id);

	if(!trunk)
		return;

	er.event = UM_EVENT_MAKE_IDLE;
	er.p1 = er.p2 = 0;
	SendMessage(trunk, &er);
}

void Session::exitTGI(int id, int excode)
{
	EventRecord er;
	Trunk *trunk = getVpbTrunk(id);

	if(!trunk)
		return;

	er.event = UM_EVENT_EXIT_SHELL;
	er.p1 = excode;
	er.p2 = 0;
	SendMessage(trunk, &er);
}

void Session::ringTrunk(int id)
{
	EventRecord er;
	Trunk *trunk = getVpbTrunk(id);

	if(!trunk)
		return;

	er.event = UM_EVENT_RING_LINE;
	er.p1 = er.p2 = 0;
	SendMessage(trunk, &er);
}

void Session::callTrunk(int id, char *scr)
{
	bool search = false;
	EventRecord er;
	Trunk *trunk;
		
	if(!id)
	{
		id = getDriverPorts();
		search = true;
	}

	trunk = getVpbTrunk(id);
	if(!trunk)
		return;

	if(search)
		er.p1 = id;
	else
		er.p1 = 0;
	SendMessage(trunk, &er);
}

Trunk* getVpbTrunk(int id)
{
	if(id < 1 || id > getDriverPorts())
		return NULL;

	return Session::trunks[--id];
}


