// Copyright (C) 1999-2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include <sessionmap.h>

class Session : public Sessionmap
{
private:
	static Trunk **trunks;

protected:
	void setIdle(int id);
	void setBusy(int id);
	void ringTrunk(int id);
	void callTrunk(int id, char *scr);
	void exitTGI(int id, int code);

public:
	Session(int count);
	~Session();

	inline Trunkmap* getTrunkHandler(int id)
		{return (Trunkmap *)getVpbTrunk(id);};

	inline int getTrunkCount(void)
		{return getDriverPorts();};

	friend int initDriver(char *scr, int ports);
	friend int stopDriver(void);
	friend Trunk *getVpbTrunk(int id);

	friend class Trunk;
};

