// Copyright (C) 1999-2000 Open Source Telecom Corporation
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include <assert.h>
#include <config.h>
#include <debug.h>
#include "server.h"
#include "trunk.h"
#include "vpbapi.h"

// DR 8/10/99, event callback function.  This function is called by
// the VPBAPI when an event occurs.
static void callTrunk(VPB_EVENT *e, void *context)
{
        Trunk *trk = (Trunk*)context;
	EventRecord er;

	if(!trk)
		return;

	char s[VPB_MAX_STR];
	vpb_translate_event(e, s);
	//debug(2, "%s",s);

	er.event = e->type;
	er.p1 = e->data;
	er.p2 = 0;
	SendMessage(trk, &er);
}		

int	Trunk::ls_answer = 3000;
int	Trunk::ls_change = 8000;
int	Trunk::ls_dialtone = 3000;
char	*Trunk::ls_pattern = NULL;

Trunk::Trunk(Runmap *map, char *scr) : Trunkmap(map, scr), Mutex()
{
	setCurrent("STARTING...");

	// start vpb first, as vpb functions called in setHandler

	hTrk = vpb_open(1,1);
	vpb_set_event_callback(hTrk, callTrunk, (void*)this);
	vpb_sethook_sync(hTrk, VPB_ONHOOK);
	vpb_timer_open(&vpb_timer, hTrk, 0, 1000);

	setHandler((handler_t)&Trunk::Idle);
}

Trunk::~Trunk() 
{
        vpb_timer_close(vpb_timer);
	vpb_set_event_callback(hTrk, NULL, NULL);
	vpb_close(hTrk);
}

void Trunk::PostMessage(EventRecord *er)
{
	switch(er->event)
	{
	case VPB_TIMEREXP:
		if(!timer)
			return;
		break;
	case VPB_DIGIT:
		if(!dtmf)
			return;
		break;
	}
	(this->*handler)(er);
}

void Trunk::setHandler(handler_t h)
{
	EventRecord e;
	
	e.event = UM_EVENT_ENTER_STATE;
	e.p1 = 0;
	e.p2 = 0;
	handler = h;
	//assert(0);
	PostMessage(&e);
}

void Trunk::exitModule(char *errmsg, int id)
{
	EventRecord e;

	e.event = UM_EVENT_EXIT_MODULE;
	e.p1 = (PK_U32)errmsg;
	e.p2 = id;
	PostMessage(&e);
}

void Trunk::scrHangup(void)
{
	if(trap && waitpid)
		waitpid = 0;

	trap = false;
	setHandler((handler_t)&Trunk::Idle);
}

void Trunk::scrStop(void)
{
	EventRecord e;

	e.event = UM_EVENT_STOP_STATE;
	e.p1 = 0;
	e.p2 = 0;
	PostMessage(&e);
}		

void Trunk::setDTMF(void)
{
	if(dtmf)
		return;

	dtmf = true;
	vpb_enable_event(hTrk, VPB_MDTMF);	
}

void Trunk::endDTMF(void)
{
	if(!dtmf)
		return;

	dtmf = false;
	vpb_disable_event(hTrk, VPB_MDTMF);
}

void Trunk::setTimer(PK_WORD timeout)
{
	timer = timeout;
	vpb_timer_stop(vpb_timer);
	vpb_timer_change_period(vpb_timer, timeout);
	vpb_timer_start(vpb_timer);
}

void Trunk::endTimer(void)
{
	timer = 0;
	vpb_timer_stop(vpb_timer);
}

void SendMessage(Trunk *trk, EventRecord *er)
{
	trk->EnterMutex();
	trk->PostMessage(er);
	trk->LeaveMutex();
};


