// Copyright (C) 1999-2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include <trunkmap.h>
#include <runmap.h>

#define PK_MAKE_EVENT(arg1, arg2)       (arg1+arg2)

#define	UM_SERVER_EVENTS		0x8000
#define	UM_EVENT_ENTER_STATE		PK_MAKE_EVENT(UM_SERVER_EVENTS, 0)
#define	UM_EVENT_INITIALIZE_PORT	PK_MAKE_EVENT(UM_SERVER_EVENTS, 1)
#define UM_EVENT_MAKE_BUSY		PK_MAKE_EVENT(UM_SERVER_EVENTS, 2)
#define UM_EVENT_MAKE_IDLE		PK_MAKE_EVENT(UM_SERVER_EVENTS, 3)
#define	UM_EVENT_STOP_STATE		PK_MAKE_EVENT(UM_SERVER_EVENTS, 4)
#define	UM_EVENT_EXIT_SHELL		PK_MAKE_EVENT(UM_SERVER_EVENTS, 5)
#define UM_EVENT_RING_LINE		PK_MAKE_EVENT(UM_SERVER_EVENTS, 6)
#define	UM_EVENT_START_LINE		PK_MAKE_EVENT(UM_SERVER_EVENTS, 7)
#define UM_EVENT_ERROR_ABORT		PK_MAKE_EVENT(UM_SERVER_EVENTS, 8)
#define UM_EVENT_EXIT_MODULE		PK_MAKE_EVENT(UM_SERVER_EVENTS, 9)

class Trunk;

#define PK_U32 long
#define PK_WORD int

typedef	struct
{
	PK_U32	event, p1, p2;
}	EventRecord;

//typedef void (*event_t)(PK_U32, PK_U32, PK_U32, PK_U32);
typedef	void (Trunk::*handler_t)(EventRecord *er);


class Trunk : public Trunkmap, public Mutex
{
private:
	static int ls_answer, ls_change, ls_dialtone;
	static char *ls_pattern;

	//TResourceHandle hTimer, hDsp, hTrk;
	//TPortHandle hPort;
	int  hTrk;
	void *vpb_timer;

protected:
	char *runmap;
	
	void (Trunk::*handler)(EventRecord *er);
	void setHandler(handler_t h);
	void setTimer(PK_WORD timeout);
	void endTimer(void);
	void setDTMF(void);
	void endDTMF(void);
	void scrHangup(void);
	void scrStop(void);
	void exitModule(char *errmsg, int id);

	void scrFlash(void)
		{setHandler((handler_t)&Trunk::FlashOn);};

	void scrModule(void)
		{setHandler((handler_t)&Trunk::Module);};
	
	void scrSay(void)
		{setHandler((handler_t)&Trunk::Say);};

	void scrPlay(void)
		{setHandler((handler_t)&Trunk::Play);};

	void scrExWait(void)
		{setHandler((handler_t)&Trunk::ExWait);};

	void scrSleep(void)
		{setHandler((handler_t)&Trunk::TrkSleep);};

	void scrWait(void)
		{setHandler((handler_t)&Trunk::TrkWait);};

	void scrAnswer(void)
		{setHandler((handler_t)&Trunk::Answer);};

	void scrBusyout(void)
		{setHandler((handler_t)&Trunk::Busy);};

	void scrDial(void)
		{setHandler((handler_t)&Trunk::Dial);}

	void scrCollect(void)
		{setHandler((handler_t)&Trunk::Collect);};

	void scrRecord(void)
		{setHandler((handler_t)&Trunk::Record);};

	char *getExtension(void)
		{return ".wav";};

	void Busy(EventRecord *er);
	void Idle(EventRecord *er);
	void Answer(EventRecord *er);
	void Default(EventRecord *er);

	void PostMessage(EventRecord *er);
	void TrkSleep(EventRecord *er);
	void TrkWait(EventRecord *er);
	void ExWait(EventRecord *er);
	void Module(EventRecord *er);
	void Say(EventRecord *er);
	void Play(EventRecord *er);
	void StopPlay(EventRecord *er);
	void Collect(EventRecord *er);
	void Record(EventRecord *er);
	void Dial(EventRecord *er);
	void FlashOn(EventRecord *er);
	void FlashOff(EventRecord *er);

public:
	Trunk(Runmap *map, char *scr = NULL);
	virtual ~Trunk();

	friend void SendMessage(Trunk *trk, EventRecord *er);
};

extern Trunk **trunks;



