/*
 *  Flasher Source File
 *
 *  GNU Copyright (C) 2003 Gaspar Sinai <gsinai@yudit.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, version 2,
 *  dated June 1991. See file COPYYING for details.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "exception.h"

namespace FLASHER
{
  /*!
   * \brief Construct a new Exception.
   * \param message is the error message.
   */
  Exception::Exception (const StringStream& message)
  {
    m_message = message;
  }

  /*!
   * \brief Copy an Exception.
   * \param e is the exception to copy.
   */
  Exception::Exception (const Exception& e)
  {
    m_message = e.m_message;
  }

  /*!
   * \return the error string.
   */
  const char*
  Exception::toString() const
  {
    return (const char*)m_message;
  }

  /*!
   * \brief assign an exception.
   * \param e is the exception to assign.
   */
  Exception&
  Exception::operator= (const Exception& e)
  {
    m_message = e.m_message;
    return *this;
  }
}
