/*
 *  Flasher Source File
 *
 *  GNU Copyright (C) 2003 Gaspar Sinai <gsinai@yudit.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, version 2,
 *  dated June 1991. See file COPYYING for details.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef flasher_exception_h
#define flasher_exception_h

#include "simple_stream.h"

namespace FLASHER
{
  /*!
   * \class Exception
   * \brief A Generic Exception.
   */
  class Exception  
  {
  public:
    Exception (const StringStream& message);
    Exception (const Exception& e);

    const char* toString() const;
    Exception& operator= (const Exception& e);

  private:
    StringStream   m_message;
  };
}

/*
 * Throw an exception with file and line numeber.
 */
#define THROW(_msg) \
 throw FLASHER::Exception ((StringStream) \
   _msg << " in "  << __FILE__ << " at " << __LINE__)

#endif /* flasher_exception_h */
