/*
 *  Flasher Source File
 *
 *  GNU Copyright (C) 2003 Gaspar Sinai <gsinai@yudit.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, version 2,
 *  dated June 1991. See file COPYYING for details.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef m16c_flasher_h
#define m16c_flasher_h

#include "serial.h"
#include "generic_flasher.h"
#include "tidbits.h"

namespace FLASHER
{
  /*!
   * \struct M16CBlock
   * \brief defined the blocks for M16C. Not all
   *   the blocks are present, it depends on the
   *   actual type of the CPU.
   */
  typedef struct
  {
    unsigned int  begin;
    unsigned int  end;
    unsigned char flag;
  } M16CBlock;

  /*!
   * \class M16CBlockModel
   * \brief M16C has blocks in addition to pages. This is the model for that.
   */
  class M16CBlockModel
  {
  public:
    M16CBlockModel(void);
    ~M16CBlockModel();

    M16CBlock& mapBlock(unsigned long address);
    M16CBlock& getBlock(unsigned int block);
    unsigned int size() const;
  protected:
    M16CBlock block[7];
  };

  /*!
   * \typedef Status
   * \brief The definition of a status flag.
   */
  typedef Byte Status;

  /*!
   * \class M16CFlasher
   * \brief This class is manipulating the flash memory that is 
   *   built in M16C Microcontrollers.
   */
  class M16CFlasher : public Flasher
  {
  public:
    M16CFlasher (Serial& port, bool verbose=true);
    ~M16CFlasher();

    bool         checkID(const char* id);
    MemoryModel* read (unsigned long from, unsigned long until, bool ie); 
    MemoryModel* readBoot (unsigned long from, unsigned long until, bool ie); 
    void execute (const MemoryModel& model); 
    void writeLock (const MemoryModel& model); 
    void write (const MemoryModel& model); 
    const char*  readVersion();
    MemoryModel* readLock (bool ie); 

  protected:
    unsigned char changeBaudRate (Serial::BaudRate from, Serial::BaudRate to);

    void sendCommand (unsigned char commmand);
    void sendByte (unsigned char byte);
    void sendAddress (unsigned long address);
    void sendShortAddress (unsigned short address);

    unsigned char getBaudCommand(Serial::BaudRate br) const;

    unsigned char receiveByte();

    void          readStatus();

    Serial&       m_port;
    bool          m_verbose;
    Status        m_status[2];
    char          m_version[10];
  };
}

#endif/* m16c_flasher_h */
