/*
 *  Flasher Source File
 *
 *  GNU Copyright (C) 2003 Gaspar Sinai <gsinai@yudit.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, version 2,
 *  dated June 1991. See file COPYYING for details.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef simple_stream
#define simple_stream

#include <stdio.h>

namespace FLASHER
{
  /*!
   * \class StringStream
   * \brief A program that does not wish to use the standard templates
   *  library, could use this class to mimic STL-like stream constructs.
   */
  class StringStream
  {
  public:
    StringStream (void);
    StringStream (const char* str);
    StringStream (long d);
    StringStream (unsigned long d, unsigned int radix);

    ~StringStream();
    StringStream (const StringStream& str);
    StringStream& operator=(const StringStream& str);
    StringStream& operator << (const StringStream& str);
    operator const char*() const;
    bool operator == (const  StringStream& str) const;
    bool operator != (const  StringStream& str) const;
  protected:
    unsigned int  m_size;
    char*         m_buffer;
  };

  /*!
   * \class Logger
   * \brief A class to log messages.
   */
  class Logger
  {
  public:
    Logger (const char* prefix, FILE*& logfile);
    ~Logger();
    void log (const StringStream& str, bool endline=true);
    void flush();
  private:
    StringStream  m_prefix;
    FILE*&        m_file;
  };
}

#endif /* simple_stream */
