/*
 *  Flasher Source File
 *
 *  GNU Copyright (C) 2003 Gaspar Sinai <gsinai@yudit.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, version 2,
 *  dated June 1991. See file COPYYING for details.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "flasher.h"

#include <stdlib.h>
#include <string.h>

using namespace FLASHER;

// This is a simple port tester.
static void test_port();

// This is a tidbits tester.
static void test_tidbits();

// This is a memory_model tester.
static void test_memory_model();

// This is a simple_stream tester.
static void test_simple_stream();

/*!
 * \brief Flasher Tester Program.
 */
int
main (int argc, char* argv[])
{
  if (argc<2) return 1;
  StringStream command(argv[1]);
  try {
    if (command == (StringStream) "port") test_port();
    if (command == (StringStream) "tidbits") test_tidbits();
    if (command == (StringStream) "memory_model") test_memory_model();
    if (command == (StringStream) "simple_stream") test_simple_stream();
  }
  catch (const Exception& e)
  {
    fprintf (stderr, "flash_tester: test failed - %s\n", e.toString());
    return 1;
  }
  return 0;
}

static void test_port()
{
  Serial serial("/dev/ttyS1");
  unsigned char c = serial.read ();
}

static void test_tidbits()
{
  
  if (sizeof (Bits) != 1)
  {
    THROW ("Bits has size: " << sizeof (Bits));
  }
  Byte byte;
  byte.byte = 0xaA5;
  if (byte.bits.bit0 != 1) THROW ("bit[0] Error" << byte.bits.bit0);
  if (byte.bits.bit1 != 0) THROW ("bit[0] Error" << byte.bits.bit1);
  if (byte.bits.bit2 != 1) THROW ("bit[0] Error" << byte.bits.bit2);
  if (byte.bits.bit3 != 0) THROW ("bit[0] Error" << byte.bits.bit3);
  if (byte.bits.bit4 != 0) THROW ("bit[0] Error" << byte.bits.bit4);
  if (byte.bits.bit5 != 1) THROW ("bit[0] Error" << byte.bits.bit5);
  if (byte.bits.bit6 != 0) THROW ("bit[0] Error" << byte.bits.bit6);
  if (byte.bits.bit7 != 1) THROW ("bit[0] Error" << byte.bits.bit7);
}

static void test_memory_model()
{
  unsigned long size = 0x1001;
  MemoryModel memory(size);
  for (unsigned int i=0; i<size; i++)
  {
    if (memory.isSet (i)) THROW ("MemoryModel failed");
    if (memory.get (i) != 0xff) THROW ("MemoryModel failed");
    if (memory.get (i, 12) != 12) THROW ("MemoryModel failed");
  }
  memory.set (0, 0x5a);
  memory.set (1, 0x55);
  memory.set (size-1, 0xa5);
  for (unsigned int i=2; i<size-1; i++)
  {
    if (memory.isSet (i)) THROW ("MemoryModel failed");
    if (memory.get (i) != 0xff) THROW ("MemoryModel failed");
    if (memory.get (i, 12) != 12) THROW ("MemoryModel failed");
  }
  if (!memory.isSet (0)) THROW ("MemoryModel failed");
  if (memory.get (0) != 0x5a) THROW ("MemoryModel failed");
  if (!memory.isSet (1)) THROW ("MemoryModel failed");
  if (memory.get (1) != 0x55) THROW ("MemoryModel failed");
  if (!memory.isSet (size-1)) THROW ("MemoryModel failed");
  if (memory.get (size-1) != 0xa5) THROW ("MemoryModel failed");
  bool bound = false;
  try {
     memory.get (size, 0xff);
     THROW ("MemoryModel failed");
  }
  catch (const Exception& e)
  {
  }
}

static void
test_simple_stream()
{
  StringStream s;
  s << "Hello" << 123 << " " << StringStream(42331, 16);
  if (strcmp ("Hello123 A55B", s)!=0)
  {
    THROW ("StringStream test failed: " << s);
  }
  s = StringStream ();
  s << "Hello" << 0x10 << " " << StringStream(0, 16);
  if (strcmp ("Hello16 0", s)!=0)
  {
    THROW ("StringStream test failed: " << s);
  }
}
