#=======================================================================
# Newtonlink   - transfer data between a Apple Newton Message Pad and
#                Unix applications
#
# Copyright (C) 1996-1998    The Newtonlink Developers
#                            (newtonlink@newton.bawue.de)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#=======================================================================

#---------------------------------------------------------------------
# GetCards
#
# This function reads the contents of all Newton cards and writes it
# to a file $NLCardsFile. This file can be used to create application
# specific input files like .addresses.dat
#
# Each line of this file shows the content of one Newton card in the
# following order (separated by colons) :
# class; last name; first name; honorific; address; country; postalcode;
# city; birthday; home phone; work phone; fax phone; email; company;
# If class is "group", the line contents the following :
# class; group name; group members
#---------------------------------------------------------------------

# $Log: GetCards.pl,v $
# Revision 1.1  1998/08/28 15:55:49  kalli
# Initial revision
#


sub GetCards {
    
    if ($CardsAreActual ne "true") {

        select((select(STDOUT), $|=1)[$[]);

        # start counter
        $PersonAddressesCounter = 0;
        $CompanyAddressesCounter = 0;
        $EmailGroupsCounter = 0;
        $Cardn = 0;

        # save old Newtonlink cards file
        if (-e "$NLCardsFile") {
	    rename ("$NLCardsFile", "$NLCardsFile.bak");
        }

        # Open file
        open (CARDSFILE, ">> $NLCardsFile")  || die "Can't open File : $!\n";

        printf "\nScanning for person and company cards ...\n";

        # send commands to Sloup
        &send_line (COMNEWTON, "Sloup");
        &send_line (COMNEWTON, "{}");
        &send_line (COMNEWTON, "Names");
        &send_line (COMNEWTON, '{class: "string", name: {last: "string", first: "string", honorific: "string"},' .
                               'address: "string", country: "string", postal_code: "string", city: "string", bday: "date",' .
                               'phones: ["homePhone", "workPhone", "faxPhone"],' .
                               'email: "string", company: "string"}');
        &send_line (COMNEWTON, "DUMP!");

        while (($_ = &receive_line (COMNEWTON)) ne "BYE!") {

	    # replace german Umlaute
	    s/\232//g; s/\212//g; s/\237//g; s/\247//g; s/\205//g; s/\200//g; s/\206//g;
	    # split into
	    ($Cardclass, $CardlastName, $CardfirstName, $Cardhonorific, $Cardaddress, $Cardcountry, $Cardpostal_code, $Cardcity,
	     $Cardbday, $CardhomePhone, $CardworkPhone, $CardfaxPhone, $Cardemail, $Cardcompany) = split(/\t/, $_, 20);

	    if (defined ($Cardclass) && (($Cardclass eq "person") || ($Cardclass eq "owner"))) {

	        # Print to STDOUT
	        print "#";
	        $PersonAddressCounter++;
	        # save to memory
	        $CardsArr[$Cardn++] = "$Cardclass;$CardlastName;$CardfirstName;$Cardhonorific;$Cardaddress;$Cardcountry;$Cardpostal_code;$Cardcity;$Cardbday;$CardhomePhone;$CardworkPhone;$CardfaxPhone;$Cardemail;$Cardcompany;";

	    } elsif (defined ($Cardclass) && ($Cardclass eq "company")) {

	        # Print to STDOUT
	        print "#";
	        $CompanyAddressCounter++;
	        # save to memory
	        $CardsArr[$Cardn++] = "$Cardclass;$Cardcompany;;;$Cardaddress;$Cardcountry;$Cardpostal_code;$Cardcity;;;$CardhomePhone;$CardfaxPhone;$Cardemail;;";

	    }
        }

        printf "\nNow scanning for email groups ...\n";
    
        # reopen Newton connection for IRIX !
        if ($SystemType eq "IRIX") {
            close COMNEWTON;
            open (COMNEWTON, "+>$tty");
            &SetSlurpeeBaudrate;
            printf (COMNEWTON "\n");
        }
    
        # send commands to Sloup : Send Email groups
        &send_line (COMNEWTON, "\nNames");
        &send_line (COMNEWTON, '{class: \'symbol, group: "string", members: [{email: "string"}]}');
        &send_line (COMNEWTON, "DUMP!{fieldDelimiter: \";\"}");

        while (($_ = &receive_line (COMNEWTON)) ne "BYE!") {

   	    if ($_ ne "\n") {

	        # split into
	        @Arre = split(/;/, $_);

	        # if group entry
	        if ($Arre[0] eq "group") {

		    # Print to STDOUT
		    print "#";
	            $EmailGroupsCounter++;
	            # save to memory
	            $CardsArr[$Cardn++] = $_;
                }
            }
        }

        # print to stdout
        print ("\n$PersonAddressCounter person addresses transfered\n");
        print ("$CompanyAddressCounter company addresses transfered\n");
        print ("$EmailGroupsCounter email groups transfered\n");

        # write cards file
        for ($Cardi = 0; $Cardi < $Cardn; $Cardi++) {
   	    printf CARDSFILE "$CardsArr[$Cardi]\n";
        }

        # close file
        close (CARDSFILE);

        # mark cards file as actual
        $CardsAreActual = "true";
    }
}

1;
