#=======================================================================
# Newtonlink   - transfer data between a Apple Newton Message Pad and
#                Unix applications
#
# Copyright (C) 1996-1998    The Newtonlink Developers
#                            (newtonlink@newton.bawue.de)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#=======================================================================

#---------------------------------------------------------------------
# InstallPackage
#---------------------------------------------------------------------

# $Log: InstallPackage.pl,v $
# Revision 1.15  1998/03/16 14:58:39  kalli
# Umstellung auf ser. Teiber mit Timeout
#
# Revision 1.14  1998/03/12 20:39:48  kalli
# Unix basename Kommando durch Perl-Lib ersetzt
#
# Revision 1.13  1998/03/07 17:46:53  kalli
# Umstellung auf neue ser. Treiber
#
# Revision 1.12  1997/12/06 17:11:29  kalli
# Umstellung auf Sloup
#
# Revision 1.11  1997/10/01 18:05:40  kalli
# Bugfix von Andrew : .slp-File wird richtig geloescht.
#
# Revision 1.10  1997/09/28 10:05:39  kalli
# Aenderung von Andrew :
# Select-Statement
#
# Revision 1.9  1997/07/12 16:06:07  kalli
# Aenderungen von Andrew wg. der Tk-Version
#
# Revision 1.8  1997/04/20 15:32:17  kalli
# .slp-File wird in $TempDir angelegt und nach Installation
# wieder geloescht.
#
# Revision 1.7  1997/03/27 19:45:31  kalli
# Andrew dazu
# Wait-Message beim Installieren
#
# Revision 1.6  1997/03/06 18:53:33  kalli
# erste Version lauffaehig
#
# Revision 1.5  1997/03/02 21:47:26  kalli
# Umstellung auf Install via Sloup
#
# Revision 1.4  1997/02/23 15:13:13  kalli
# Frank dazu
#
# Revision 1.3  1997/02/22 17:02:19  kalli
# GPL dazu
#
# Revision 1.2  1997/01/05 16:05:37  kalli
# Neuer Aufruf : minicom
#
# Revision 1.1  1996/11/24 19:57:38  kalli
# Initial revision
#

use File::Basename;

sub InstallPackage {

    select((select(STDOUT), $|=1)[$[]);
    $LineCounter = 0;
    $TByte = "";
    $PkgByteCounter = 0;

    # open Newton package file
    open (PKGFILE, "$PackageFile")  || die "Can't open File $PackageFile : $!\n";
    binmode PKGFILE;

    #extract file's basename
    $PackageFile =~ s/\\/\//g;
    ($tempFile) = reverse(split(/\//, $PackageFile));
    ($tempFile) = split(/\./, $tempFile);

    # open Sloup Hex file 
    $tempFile = "$TempDir\/$tempFile.slp";
    print "$tempFile\n";
    open (SLPFILE, ">$tempFile")  || die "Can't open File : $!\n";

    # print message
    print "Converting package file, please wait ...\n";

    # read byte from package file
    while (read (PKGFILE, $TByte, 1)) {

	# write to Sloup Hex file
	printf (SLPFILE "%02X", ord($TByte));

	# insert "\\n" every 36 bytes
	if ($LineCounter == 36) {
	    printf SLPFILE ("\\\n");
	    $LineCounter = 0;
	} else {
	    $LineCounter++;
	}
	
	# incr bytecounter
	$PkgByteCounter++;
    }

    # close files
    close (PKGFILE);
    close (SLPFILE);

    # print bytecounter
    print "Package size is $PkgByteCounter bytes\n";

    # open file
    open (SLPFILE, $tempFile) || printf "Can't open file : $!\n";

    # print message
    print "Installing package, please wait ...\n";

    # send commands to Sloup
    &send_line (COMNEWTON, "\nPackage");
    &send_line (COMNEWTON, "{packageName: \"string\", packageEntry: \"binary:packageEntry\"}");
    &send_line (COMNEWTON, "REPLACE!packageName");
    &send_line (COMNEWTON, "LoadPkg	!\\");

    # read lines from file
    while (<SLPFILE>) {

	# send line to Sloup
	&send_line (COMNEWTON, "$_");
	print "#";
    }

    &send_line (COMNEWTON, "BYE!");
    print("\nPackage transferred\n");
    # close file
    close (SLPFILE);
    # delete file
    unlink $tempFile;

}

1;
