/*==========================================================
 * Program : sendsms.h                     Project : smslink
 * Author  : Philippe Andersson.
 * Date    : 03/06/04
 * Version : 0.04b
 * Notice  : (c) Les Ateliers du Heron, 1998 for Scitex Europe, S.A.
 * Comment : Main include file for sms client.
 *
 * Modification History :
 * - 0.01a (28/09/98) : Initial release.
 * - 0.02a (21/10/98) : Added BIGBUFF define.
 * ++++ Switched to Beta ++++
 * - 0.03b (23/10/98) : Added MAXUIDLEN define.
 * - 0.04b (03/06/04) : Added support for queued message priority
 *   (added SMS_Q_PRI_FLOOR, SMS_Q_PRI_CEIL).
 *========================================================*/

#ifndef _SENDSMS_H
#define _SENDSMS_H

/* Program information */
#define SMS_CLI_VERSION		"0.24b"
#define SMS_CLI_DATE		"11/03/05"
#define SERVPROMPT		"SMS> "

/* Buffer handling */
#define BUFFSIZE		400
#define MINIBUFF		80		/* for hostname, for inst. */
#define BIGBUFF			1024

/* SMS Messages-related */
#define MAXPHNUMLEN		80		/* max length for phone num */
#define MAXMSGLEN		160		/* max msg length for SMS */
#define MAXUIDLEN		12		/* max length for sender ID */
#define DEFAULTSMSC		"075/16.16.16"	/* Proximus OK */
#define DEFSMSPORT		6701		/* port server listens to */
#define SMS_Q_PRI_FLOOR		1		/* min. priority id (1=highest) */
#define SMS_Q_PRI_CEIL		5		/* max. priority id (5=lowest) */

/* Server-side actions */
#define SMS_ACTION_SEND		0
#define SMS_ACTION_POST		1
#define SMS_ACTION_QUEUE	2

/* Can be usefull */
#define TRUE        1
#define FALSE       0

/*==========================================================
 * Structure Declarations
 *========================================================*/

/*==========================================================
 * Function Declarations
 *========================================================*/
/* --- in "?.c" --- */

#endif                              /* #ifndef _SENDSMS_H */

/*==========================================================
 * EOF : sendsms.h
 *===================*/
