/*==========================================================
 * Program : gsmdev.h                      Project : smslink
 * Author  : Philippe Andersson.
 * Date    : 12/01/05
 * Version : 0.11b
 * Notice  : (c) Les Ateliers du Heron, 1998 for Scitex Europe, S.A.
 * Comment : GSM device "driver" include file for SMSLink server.
 *
 * Modification History :
 * - 0.01a (17/05/00) : Initial release.
 * ++++ Switched to Beta ++++
 * - 0.02b (08/06/00) : Added HAS_CS_AT_PARSER define for some
 *   Wavecom modules (the WM02 for sure).
 * - 0.03b (21/06/00) : Added define for Siemens M20 (sub-prompt
 *   when requesting to send).
 * - 0.04b (18/10/00) : Added alternate CNMI handling for Siemens
 *   S25 / S35 (thanks to Thomas Omerzu <thomas@omerzu.de> for
 *   the fix).
 * - 0.05b (24/11/00) : Added ALT_CNMI_2 and HAS_CSDH_1 to support
 *   the PCFF900 model. Kudos to Bernard Willemot 
 *   <bernard_willemot@cse.creoscitex.com> for lending me the
 *   hardware.
 * - 0.06b (18/02/01) : Added ALT_CNMI_3 to support Ericsson
 *   GM12 device (contributed by Andrew Worsley 
 *   <epaanwo@asac.ericsson.se>).
 * - 0.07b (23/02/01) : Added SET_MSG_STORE to support Ericsson
 *   GM12 device. Cosmetics. Contributed by Andrew Worsley 
 *   <epaanwo@asac.ericsson.se>.
 * - 0.08b (19/02/02) : Added ALT_CNMI_4 to support Ericsson
 *   T65 device. Contributed by Ritesh Shah <riteshs@rediff.co.in>.
 * - 0.09b (15/05/01) : Moved GSM options flags over from
 *   sms_serv.h. Moved MAXMODLEN to sms_serv.h. Added "init"
 *   option flag.
 * - 0.10b (25/11/03) : Added NO_CREG_CHECK to support Motorola
 *   A008 device. Contributed by Nicki de Wet <nickidw@mighty.co.za>.
 * - 0.11b (12/01/05) : Added support for 'skip' flag.
 *========================================================*/

#ifndef _GSMDEV_H
#define _GSMDEV_H

/* "Driver" file */
#define GSMCAPS_FILE		"/etc/gsmcaps"

/* Capacity Flags */
#define HAS_TEXT_MODE		 1	/* Text mode supported */
#define HAS_PDU_MODE		 2	/* PDU mode supported */
#define STRICT_TEXT_PARAMS	 4	/* Params MUST be txt in txt mode */
#define HAS_SCA_IN_PDU	 	 8	/* SCA can be given in PDU */
                                        /* Note: NOT in GSM 03.40 (GENSM2) */
#define HAS_CS_AT_PARSER	16	/* Case-sensitive AT parser (WM02) */
#define SUBPROMPT_IN_CMGS       32      /* Wait for '>' after '\r' (SM20) */
#define ALT_CNMI        	64	/* Use CNMI=0,0,0,0,1 instead of  */
                                        /* 0,0,0,0,0 (SS25) */
#define ALT_CNMI_2             128	/* Use CNMI=1,0,0,0,0 (PCFF900) */
#define HAS_CSDH_1             256      /* Full header (not on PCFF900) */
#define ALT_CNMI_3             512	/* Use CNMI=3,0,0,0 (GM12/GM22) */
#define SET_MSG_STORE         1024	/* Use at+cpms="ME","ME" to force */
					/* new SMS messages to be stored in */
					/* the accessible memory area (GM12) */
#define ALT_CNMI_4            2048	/* Use CNMI=3,0,0,0,0 (T65) */
#define NO_CREG_CHECK         4096      /* No CREG check (A008) */

/* GSM devices flags */
#define POLL_DEVICE		(0x0)		/* default mode: poll */
#define DEDICATED_DAEMON	(0x1)		/* spawn it's own daemon - else polling */
#define SMS_PROG		(0x2)		/* feed incomming SMS to alert program */
#define SMS_INBOX		(0x4)		/* append incomming SMS to inbox */
#define SMS_DB			(0x8)		/* store SMS in MySQL DB */
#define FAST_RESPONSE		(0x10)		/* use fast method of getting GSM */
						/* modem responses */
#define SMS_READ_ALL		(0x20)		/* hack to clear SIM of msgs */
#define SMS_INIT		(0x40)		/* "initialized" mode */
#define SMS_SKIP		(0x80)		/* skip device during MBC */

/*==========================================================
 * Structure Declarations
 *========================================================*/

struct gsm_option_flags {
  char *name;
  int flag;
};

static struct gsm_option_flags option_flags_list[] = {
  {"poll", POLL_DEVICE},
  {"dd", DEDICATED_DAEMON},
  {"prog", SMS_PROG},
  {"inbox", SMS_INBOX},
  {"db", SMS_DB},
  {"fast", FAST_RESPONSE},
  {"r4", SMS_READ_ALL},
  {"init", SMS_INIT},
  {0, 0}
};

/*==========================================================
 * Function Declarations
 *========================================================*/
/* --- in ".c" --- */

#endif                               /* #ifndef _GSMDEV_H */

/*==========================================================
 * EOF : gsmdev.h
 *===================*/
