/*==========================================================
 * Program : pdu.h                         Project : smslink
 * Author  : Philippe Andersson.
 * Date    : 11/10/03
 * Version : 0.08b
 * Notice  : (c) Les Ateliers du Heron, 1998 for Scitex Europe, S.A.
 * Comment : PDU-mode include file for SMSLink server.
 *
 * Modification History :
 * - 0.01a (07/04/00) : Initial release.
 * - 0.02a (13/04/00) : Added the min() macro (moved from server.y).
 * ++++ Switch to Beta ++++
 * - 0.03b (21/11/00) : Added the decode_pdu() function definition.
 * - 0.04b (23/11/00) : Adapted the decode_pdu() function def.
 *   to include the cap_matrix field.
 * - 0.05b (18/10/01) : Exported ascii7topacked8() and
 *   ascii7topacked8() for external use.
 * - 0.06b (23/01/02) : Added a few defines for default GSM
 *   alphabet support.
 * - 0.07b (28/05/03) : Updated declaration for packed8toascii7().
 * - 0.08b (11/10/03) : TPDU flags cleanup.
 *========================================================*/

#ifndef _PDU_H
#define _PDU_H

#define min(a,b)   ( ( (a) < (b) ) ? (a) : (b) )

/*--------------------------------------------------------*/
/*               TPDU Flags (see GSM 03.40)               */
/*--------------------------------------------------------*/
/*..........................................In SMS-SUBMIT */
#define TP_MTI_SMS_SUBMIT	 1	/* Message type : SUBMIT */
#define TP_RD_REJECT             4      /* SC to reject duplicates */
#define TP_VPF_NOT_PRESENT	 0	/* No validity period field */
#define TP_VPF_RELATIVE		16	/* Relative VP field */
#define TP_VPF_ABSOLUTE		24	/* Absolute VP field */
#define TP_RP_REQUEST           32      /* Request Reply Path */
#define TP_UDHI_SUBMIT          64      /* User Data Head. Indicator */
#define TP_SRR                 128      /* Status Report Request */

/*.........................................In SMS-DELIVER */
#define TP_MTI_SMS_DELIVER	 0	/* Message type : DELIVER */
#define TP_MMS_NO_MORE_MSG	 4	/* No more msg waiting */
#define TP_MMS_MORE_MSG	 	 0	/* More msg waiting */
#define TP_RP_EXISTS             8      /* Reply Path Exists */
#define TP_UDHI_DELIVER         16      /* User Data Head. Indicator */
#define TP_SRI_SR_NOT_REQD	 0	/* No status rep. requested */
#define TP_SRI_SR_REQD		32	/* Status report requested */

/* PID */
#define PID_SMS			 0	/* Protocol ID : SMS */

/* DCS (Data Coding Scheme) */
#define DCS_PCCP437		 0	/* PCCP437 8bit -> 7bit */

/* Specific to SMSLink */
#define TP_UDL_UNKNOWN		-1	/* no <tpudl> provided */

/* GSM Default Alphabet support */
#define ESC_VALUE	     27000

#define ALPH_GSM		 0	/* GSM default alphabet */
#define ALPH_8859_1		 1	/* ISO-8859-1 charset */
#define ALPH_8859_15		 2	/* ISO-8859-15 charset */

#define DEFAULT_ALPHABET	ALPH_8859_1

/*==========================================================
 * Structure Declarations
 *========================================================*/

typedef struct charsetdef_s {
  char name[15];
  char descr[30];
  int id;
} charsetdef;

/*==========================================================
 * Function Declarations
 *========================================================*/
/* --- in "pdu.c" --- */
int transcode (int, int, int);
int ascii7topacked8 (char *, char *, int);
int packed8toascii7 (char *, char *, int, int);
char *encode_pdu (struct symbols *, int);
int decode_pdu (char *, struct mbox_item *, cap_matrix, int);
void listsupportedcharsets ();
int getcharsetID (char *);
char *getcharsetname (int);

#endif                                  /* #ifndef _PDU_H */

/*==========================================================
 * EOF : pdu.h
 *===================*/
