/*==========================================================
 * Program : sms_serv.h                    Project : smslink
 * Author  : Philippe Andersson.
 * Date    : 02/10/06
 * Version : 0.56b-3
 * Notice  : (c) Les Ateliers du Heron, 1998 for Scitex Europe, S.A.
 * Comment : Main include file for SMSLink server.
 *
 * Modification History :
 * - 0.01a (13/08/98) : Initial release.
 * - 0.02a (25/08/98) : Added section for logging facility and
 *   a function declarations section. Cosmetics.
 * - 0.10a (27/08/98) : Integration of the parser module into the
 *   main sms_serv program. Merged server.h into this file.
 *   Added code to prevent double inclusion. Cosmetics.
 * - 0.11a (01/09/98) : Increased BUFFSIZE from 200 to 400.
 * - 0.12a (27/09/98) : Added MINIBUFF define.
 * - 1.13a (19/10/98) : Added GSMDEVFILE define and function
 *   definitions for gsmdevices.c. Changed 'struct modem_def'
 *   to 'struct gsms_def' and added fields.
 * ++++ Switched to Beta ++++
 * - 0.14b (23/10/98) : Added 'user' member in 'symbols' struct
 *   and defined MAXUIDLEN.
 * - 0.15b (22/11/98) : Added MBCHKINTERVAL define.
 * - 0.16b (13/12/98) : Added member "owner" to struct gsms_def.
 * - 0.17b (06/02/99) : Added support for access control.
 *   Contributed by Philipp Klaus <pklaus@access.ch>.
 * - 0.18b (11/02/99) : Start rewriting of ACL support.
 * - 0.19b (14/02/99) : Declared public functions for new ACL
 *   implementation.
 * - 0.20b (28/06/99) : Added struct mbox_item to be used by
 *   mbcheck() and friends.
 * - 0.21b (29/06/99) : Moved 3 functions to stuff.c and made
 *   them public.
 * - 0.22b (03/07/99) : Added public definition for trim().
 * - 0.23b (11/07/99) : Added mailbox files definitions.
 * - 0.24b (17/08/99) : Added checkpoint file definition for
 *   interaction with the SMS to mail gateway.
 * - 0.25b (18/08/99) : Published mailgws_death().
 * - 0.26b (20/08/99) : Adapted structure after splitting
 *   stuff.c. Mostly cosmetic.
 * - 0.27b (25/08/99) : Added MAXRETRIES define, as well as
 *   version tracking for sms2mailgw.
 * - 0.28b (28/09/99) : Created struct email_msg and inbox_line,
 *   and exported mailbox_run(). Defined DEFAULTDOMAIN.
 * - 0.29b (17/10/99) : Added FIELD_HEADERS definition.
 * - 0.30b (20/10/99) : Added GWUSER definition.
 * - 0.31b (21/10/99) : Added MAILHOST definition. Moved tellsock()
 *   definition to stuff.c.
 * - 0.32b (09/11/99) : Added nicedate() declaration (exported by
 *   stuff.c).
 * - 0.33b (02/12/99) : Changed DEFAULTSMSC to a catch-all
 *   "default" value in order to improve its handling. See
 *   send_sms() in server.y. Added public export of empty_acl_list()
 *   to accessctrl.c (for "aclist" command).
 * - 0.34b (29/02/00) : Changed struct email_msg to replace recepients
 *   fields with linked lists for easier handling by send_mail().
 * - 0.35b (28/03/00) : Modified struct symbols to accomodate SMS mode,
 *   and added related defines.
 * - 0.36b (29/03/00) : Modified struct gsms_def to hold the SMS
 *   sending mode as well.
 * - 0.37b (07/04/00) : Modified struct symbols to hold the PDU
 *   version of the message as well.
 * - 0.38b (10/04/00) : Added export of str_insert() from stuff.c.
 * - 0.39b (17/05/00) : Added capmatrix field to struct gsms_def.
 * - 0.40b (21/06/00) : Modified the capmatrix to hold more info.
 * - 0.41b (11/09/00) : Added export of unixify() from stuff.c.
 * - 0.42b (26/09/00) : Added export of sig_chld() from serv_stuff.c.
 * - 0.43b (18/02/01) : Added MAXINTBUF #define. Increased size of
 *   BIGBUFF to 4000 (to accomodate at least 20 msgs). Added
 *   SMS_PROG_NAME and the debug flags. Added flag field to the
 *   struct gsms_def, and the accompanying flags definitions.
 *   Declared all new functions. Contributed by Andrew  
 *   Worsley <epaanwo@asac.ericsson.se>.
 * - 0.44b (19/02/01) : Added MODEM_OKAY and FAST_RESPONSE #define.
 *   Exported more functions from serv_stuff.c. Moved UNIX_PATH_MAX
 *   and BIGGERBUFF over from dd.c. Contributed by Andrew Worsley
 *   <epaanwo@asac.ericsson.se>.
 * - 0.45b (03/03/01) : Added DEBUG_PRINTF #define.
 * - 0.46b (06/03/01) : Added SMS_READ_ALL #define.
 * - 0.47b (02/04/01) : Modified PINLEN value from 4 to 5 (some
 *   new SIM cards support 5-digits PIN codes). Thanks to Jason
 *   Whiting <jason@adept.co.za> for telling me. Adapted definition
 *   of get_gsm_answer() [struct gsms_def field].
 * - 0.48b (03/04/01) : Added export for new fn spchar_pp().
 * - 0.49b (04/04/01) : Included cpl_list structs.
 * - 0.50b (03/05/01) : Exported getregstat() in serv_stuff.c
 * - 0.51b (26/09/01) : Added DEBUG_PDU #define.
 * - 0.52b (25/03/01) : Added SMS_DB, OBCHKINTERVAL and DBACCESSFILE
 *   #define to support Andrea Vettori's MySQL hack + exported the
 *   function of the new dbaccess.c file and outboxcheck_wrapper().
 * - 0.53b (26/03/01) : Added "context" concept. Exported
 *   backend_send_sms from server.y.
 * - 0.54b (30/04/01) : Added stats fields to the struct gsms_def.
 * - 0.55b (29/07/03) : Moved GSM options flags to gsmdev.h. Moved
 *   MAXMODLEN over from gsmdev.h. Added the model field to the
 *   struct gsms_def. Exported new functions from dbaccess.c, plus
 *   file_exist() from stuff.c. Added DEBUG_DBACCESS level.
 *   Exported set_cmee() & al. from serv_stuff.c. Added the
 *   DDMN context. Exported strupper(). Modified PUKLEN value
 *   from 8 to 16 (Teddy A. Jasin <teddy@efusion.com.sg> reported
 *   using a 15 char. PUK code). Added queueing methods definitions.
 *   Added the dd_busy field to struct gsms_def. Added MAXQRUNS,
 *   SMS_SERV_EXP_SCHEMA and DEBUG_SMTP.
 * - 0.56b (11/04/04) : Added a few defines in support of queued
 *   messages priority and a few others in support of the "purge"
 *   command.
 * - 0.56b-2 (22/03/06) : Increased PINLEN value again (5 to 8: some
 *   new SIM cards support 6-digits PIN codes and I'll keep a few
 *   spare chars). Thanks to "Fluff" <dune@fluffigt.net> for letting
 *   me know. Added lay_pid_file() function declaration.
 * - 0.56b-3 (02/10/06) : Bumped main SMS_SERV_VERSION. Bumped DB
 *   schema version to 5.
 *========================================================*/

#ifndef _SMS_SERV_H
#define _SMS_SERV_H

/* Program information */
#define SMS_SERV_VERSION	"0.56b-3"
#define SMS_SERV_DATE		"02/10/06"
#define PROMPT			"SMS> "

/* GSM devices */
#define GSMDEVFILE		"/etc/gsmdevices"
#define PINLEN			8
#define PUKLEN			16
#define MAXATTEMPTS		4        	/* 3 wrong PIN's + 1 PUK */
#define MAXMODLEN		15		/* max length for model */
#define CTRL_Z			"\x1A"		/* SM end marker */
#define MODEM_OKAY		"\r\nOK\r\n"	/* Modem response end marker */
				/* since it might differ between models, it */
				/* might be best to store that in the driver */

/* access control (INA) */
#define ACCESSFILE		"/etc/gsmaccess"
#define MAXACLS			10000		/* precaution */
#define ACL_ALLOW		1
#define ACL_DENY		2

/* database access */
#define DBACCESSFILE		"/etc/gsmdbtab"
#define SMS_SERV_EXP_SCHEMA	5

/* Queueing methods */
#define SMS_Q_NONE		0		/* Queueing disabled */
#define SMS_Q_FILE		1		/* Queueing through files */
#define SMS_Q_DB		2		/* Queueing in backend DB table */

/* File counter operations (qmethod == SMS_Q_FILE) */
#define SMS_FC_RST		0
#define SMS_FC_INC		1
#define SMS_FC_GET		2

/* For "outbox purge" operation */
#define DB_OUT_PURGE_SENT	1
#define DB_OUT_PURGE_FAIL	2
#define DB_OUT_PURGE_ALL	3

/* Buffer handling */
#define BUFFSIZE		400
#define MINIBUFF		80		/* for hostname, for inst. */
#define TINYBUFF		20
#define BIGBUFF			(20*(160+40))	/* 1024 overflowed with 15 msgs */
#define	BIGGERBUFF		(1024*4)
#define MAXINTBUF		20		/* size needed to sprintf an */
						/* int incl. trailing null */

/* SMS Messages-related */
#define MAXPHNUMLEN		80		/* max length for phone num */
#define MAXMSGLEN		160		/* max msg length for SMS */
#define DEFAULTSMSC		"default"	/* device-level default */
#define MAXUIDLEN		12		/* max length for sender ID */
#define SMS_MODE_DEFAULT	-1		/* device-level default mode */
#define SMS_MODE_PDU		0		/* PDU-mode SMS */
#define SMS_MODE_TEXT		1		/* Text-mode SMS */
#define SMS_PINPAUSE_DEFAULT	20		/* device-level def. PINpause */
#define SMS_DEF_Q_PRI		3		/* default queue priority */
#define SMS_Q_PRI_FLOOR		1		/* min. priority id (1=highest) */
#define SMS_Q_PRI_CEIL		5		/* max. priority id (5=lowest) */

/* Contexts */
#define CONTEXT_SEND		1		/* Regular send */
#define CONTEXT_MBCI		2		/* Mailbox check IN */
#define CONTEXT_MBCO		3		/* Mailbox check OUT */
#define CONTEXT_DDMN		4		/* Dedicated Daemon */
#define CONTEXT_MLGW		10		/* SMS to Mail Gateway */

/* For incoming messages handling */
/* A value of 0 for MBCHKINTERVAL disables mailbox checking altogether. */
/* Otherwise, make it at least 120. */
#define MBCHKINTERVAL		3600		/* mailbox check interv.(sec)*/
#define MBOX_FILE		"/var/spool/smslink/inbox"
#define MBOX_LOCKF		"/var/spool/smslink/LCK..inbox"
#define CHECKPOINTF		"/var/spool/smslink/checkpoint"
/* program to feed incomming SMS messages into */
#define SMS_PROG_NAME		"sms-recv.pl"

/* For outgoing messages handling */
/* A value of 0 for OBCHKINTERVAL disables outbox checking altogether. */
/* Otherwise, make it at least 120. */
#define OBCHKINTERVAL		0
/* Max msgs processed per queue run -- 0 means no limit */
#define OBCHKLIMIT		0
/* Any queue item not delivered after MAXQRUNS is removed. */
/* Set between 0 and 59 inclusive. 0 == no limit. */
#define MAXQRUNS		5
#define OBOX_SPOOL		"/var/spool/smslink/outbox"

/* For the SMS to Mail gateway */
#define SMS_GW_VERSION		"0.20b"
#define SMS_GW_DATE		"20/04/06"
#define MAXRETRIES		5		/* max tries to lock inbox */
#define MAILHOST		"localhost"	/* SMTP relay */
#define DEFAULTDOMAIN		"."             /* set to override server's */
#define GWUSER			"smsgw"		/* local user for mail deliv. */
#define FIELD_HEADERS		"TCRBFS"        /* supported field headers */

/* For the logging calls */
#include <syslog.h>
#define FACILITY		LOG_USER	/* default */

/* Local socket options */
#define MAXCLIENTCONN		5		/* max socket queue length */
#define MAXCHILDPROC		5		/* max child processes */
#define UNIX_PATH_MAX		108		/* an apparent explicit */
						/* constant on linux! */

/* Semaphore-related parameters */
#define MAXMODEMS		2		/* max supported modem devs */
#define M_TIMEOUT		90		/* secs wait for free modem */
#define W_STEP			5		/* secs to sleep */

/* Modem-related parameters */
#define MAXDEVLEN		40		/* max. device name length */

/* Debug flags */
#define DEBUG_TELL		(0x1)		/* log commands to GSM device */
#define DEBUG_GET_GSM_ANSWER	(0x2)		/* log GSM devices reponses */
#define DEBUG_PRINTF		(0x4)		/* send debug info to stderr */
#define DEBUG_HEXDUMP		(0x8)		/* hexdumps on modem response */
						/* and incoming SMS */
#define DEBUG_PDU		(0x10)		/* accept any PDU field value */
#define DEBUG_DBACCESS		(0x20)		/* logs SQL requests */
#define DEBUG_SMTP		(0x40)		/* dumps all SMTP dialog */
#define DEBUG_ALL		(0xffff)	/* All DEBUG */

/* Can be usefull */
#define TRUE        1
#define FALSE       0

/*==========================================================
 * Structure Declarations
 *========================================================*/
#include <unistd.h>                  /* for pid_t typedef */
#include <netinet/in.h>            /* for struct acl_item */

/* This structure defines an outbound SMS message */
struct symbols {
  char *smsc;                           /* message center */
  char *destgsm;                       /* destination gsm */
  char *message;                          /* message text */
  char *pdu;                   /* message as a PDU string */
  char *user;                    /* sender identification */
  int mode;                         /* mode (text or PDU) */
  int priority;                    /* for queued messages */
};

/* This structure stores an incoming message */
struct mbox_item {
  int msgid;                       /* used for SIM access */
  char fromgsm[MAXPHNUMLEN + 1];     /* sender GSM number */
  char date[9];                        /* format YYYYMMDD */
  char time[10];                      /* format xxhyymzzs */
  char text[MAXMSGLEN + 1];
  struct mbox_item *next;
  struct mbox_item *prev;
};

typedef struct mbox_list_header {
  struct mbox_item *head;
  struct mbox_item *tail;
} mbox_list;

typedef struct s_cap_matrix {
  unsigned int capflags;                /* capacity flags */
  char datefmt[4];        /* date format in text-mode SMS */
  char modem_okay[TINYBUFF + 1];  /* OK str for fast mode */
  char line_sep[3];                     /* line separator */
} cap_matrix;

/* This defines a gsm device instance */
struct gsms_def {
  /* status fields */
  int free;                                 /* bool value */
  pid_t owner;                    /* pid of owner process */
  int dd_busy;               /* bool: status in "dd" mode */
  /* characteristics */
  char device[MAXDEVLEN + 1];              /* device name */
  char PIN[PINLEN + 1];                       /* PIN code */
  char PUK[PUKLEN + 1];                       /* PUK code */
  char addr[MAXPHNUMLEN + 1];       /* SIM calling number */
  char defsca[MAXPHNUMLEN + 1]; /* def. Service Center Addr. */
  int PINpause;           /* secs to pause for net. logon */
  int defmode;                       /* def. sending mode */
  char model[MAXMODLEN + 1];                /* model name */
  cap_matrix capmatrix;                /* "driver" matrix */
  char provider[MAXDEVLEN + 1]; /* GSM Net. provider name */
  int flags;                           /* option features */
  /* stats counters */
  int in_ok;
  int in_fail;
  int out_ok;
  int out_fail;
  int unlocked;
};

/* structures for access control (ACL items) */
struct acl_item {
  int action;                          /* allow or reject */
  struct in_addr network;                /* network or IP */
  unsigned long nomask;                /* net. order mask */
  struct acl_item *next;
  struct acl_item *prev;
};

typedef struct acl_list_header {
  struct acl_item *head;
  struct acl_item *tail;
} acl_list;

/* structures for catch phrase lookup lists */
struct cpl_item {
  char *catch_phrase;
  struct cpl_item *next;
  struct cpl_item *prev;
};

typedef struct cpl_list_header {
  struct cpl_item *head;
  struct cpl_item *tail;
} cpl_list;

/* structures for child procs managment lists */
struct obc_proc {
  int pid;
  struct obc_proc *next;
  struct obc_proc *prev;
};

typedef struct obc_list_header {
  struct obc_proc *head;
  struct obc_proc *tail;
  int count;
} obc_list;

/*--------------------------------------------------------*/
/* Structures for the SMS to Mail gateway */
struct inbox_line {
  char device[MAXDEVLEN + 1];          /* GSM device file */
  int msgid;                       /* used for SIM access */
  char fromgsm[MAXPHNUMLEN + 1];     /* sender GSM number */
  char date[9];                        /* format YYYYMMDD */
  char time[10];                      /* format xxhyymzzs */
  char text[MAXMSGLEN + 1];
};

/*==========================================================
 * Function Declarations
 *========================================================*/
/* --- in "stuff.c" --- */
int file_exist (char*);
int lay_pid_file (char*);
int shiftleft (char*, int);
int l_basename (char*);
char *l_stpcpy (char *, char *);
int str_insert (char *, int, char);
int dequote (char *);
int strupper (char *);
int trim (char *);
int unixify (char *);
int spchar_pp (char *);
void dump_string (const char *);
int deslashdot (char *);
char *nicedate (char *);
void tellsock (int, char *);
void syserr (char *);
void fatal (char *);
char *trChar (char *s, int old, int newc);

/* --- in "serv_stuff.c" --- */
void obc_list_init (obc_list *);
int empty_obc_list (obc_list);
void obc_list_insert (obc_list *, int);
void obc_snip (obc_list *, struct obc_proc *);
void obc_remove (obc_list *, int);
void free_obc_list (obc_list *);
void cpl_list_init (cpl_list *);
int empty_cpl_list (cpl_list);
void cpl_list_insert (cpl_list *, char *);
void free_cpl_list (cpl_list *);
void daemons_death ();           /* main exit function for sms_serv */
void sig_chld ();                /* SIGCHLD handler */
int tell_gsm (int, char *);
int get_gsm_answer (int, char *, int, int, struct gsms_def *);
int get_gsm_resp (int, char *, int, int, cpl_list);
int get_gsm_fast (int, char *, int, int, cpl_list);
int get_gsm_sleep (int, char *, int, int);
int getregstat (char *);
int set_cmee (struct gsms_def *, int, int);
int set_cnmi_on (struct gsms_def *, int, int);
int set_cnmi_off (struct gsms_def *, int, int);
int set_cpms (struct gsms_def *, int, int);
int set_csdh (struct gsms_def *, int, int);
int checkset_cpin (struct gsms_def *, int, int, int *);
int checkset_csca (struct gsms_def *, int, int, char *);
int checkset_cmgf (struct gsms_def *, int, int, int);
int check_creg (struct gsms_def *, int, int);
int initialize_gsm (struct gsms_def *);
int file_counter_op (char *, int);
int sms_queue_file (void);
int file_list_queue (int);
int file_queue_delete (int);
int set_semvalue (int, int);
int sem_wait (int);
int sem_decreq (int);
int sem_signal (int);
void cleanup_mdm (const char *msg, int fd);

/* --- in "gw_stuff.c" --- */
void mailgws_death ();           /* main exit function for sms2mailgw */
int mailbox_run (char *, char*, char*);

/* --- in "mbchecker.c" --- */
void mbcheck_wrapper (void);
void outboxcheck_wrapper (void);
struct mbox_item *mbparse (char *msg_string, cap_matrix capmatrix);
struct mbox_item *mbparsePDU (char *msg_string, cap_matrix capmatrix);

/* --- in "accessctrl.c" --- */
int empty_acl_list (acl_list);
void acl_list_init (acl_list *);
void free_acl_list (acl_list *);
int read_acl (acl_list *);
int check_acl (struct in_addr *, acl_list);

/* --- in "dbaccess.c" --- */
int got_db_creds (void);
int got_any_creds (void);
int load_db_creds (void);
int sms_queue_db (void);
int db_list_queue (int);
int db_queue_delete (int);
int db_purge_inbox (void);
int db_purge_outbox (int);

/* --- in "gsmdevices.c" --- */
int gsmdevcpy (struct gsms_def *, struct gsms_def *);
static int open_gsmdevs (void);
static void close_gsmdevs (void);
struct gsms_def *getgsmdevbynam (char *);
int getgsmdevscount (int);
void setgsmdevs (void);
struct gsms_def *getnextgsmdev (void);
static int demangle_gsmdev_entry (struct gsms_def *, char *);

/* -- in dedicated.c -- */
void dd_spawn (struct gsms_def *dev);
int dd_init (struct gsms_def *gsm);
int dd_notify (struct gsms_def *gsm, int fd);
int dd_input (struct gsms_def *dev, int fd);
int dd_clear_msgs (struct gsms_def *gsm, int fd);
int dd_send_sms (struct gsms_def *gsm, int fd, struct symbols *pSMS, int csfd);

/* --- in "server.y" --- */
int parser ();                           /* parser module */
int my_yyinput (char *, int);       /* new input for flex */
int backend_send_sms (struct gsms_def *, struct symbols *, int);

/* --- in "server.l" --- */
void yyerror (const char *);

#endif                             /* #ifndef _SMS_SERV_H */

/*==========================================================
 * EOF : sms_serv.h
 *===================*/
