/*==========================================================
 * Program : smtp.h                        Project : smslink
 * Author  : Philippe Andersson.
 * Date    : 26/06/03
 * Version : 0.01a
 * Notice  : (c) Les Ateliers du Heron, 2003
 * Comment : SMTP include file for SMSLink server.
 *
 * Modification History :
 * - 0.01a (26/06/03) : Initial release.
 *========================================================*/

#ifndef _SMTP_H
#define _SMTP_H

#define MAILHOST		"localhost"	/* SMTP relay */
#define DEFAULTDOMAIN		"."             /* set to override server's */
#define DEFLT_SENDER		"SMS_DAEMON"	/* bounced messages from: addr. */
#define BOUNCE_ADDR		"postmaster"	/* who's getting the bounced msgs */

/*==========================================================
 * Structure Declarations
 *========================================================*/
struct rcpt_item {
  char *rcpt;
  struct rcpt_item *prev;
  struct rcpt_item *next;
};

struct body_line {
  char *line;
  struct body_line *prev;
  struct body_line *next;
};

typedef struct rcpt_list_header {
  struct rcpt_item *head;
  struct rcpt_item *tail;
} rcpt_list;

typedef struct body_list_header {
  struct body_line *head;
  struct body_line *tail;
} body_list;

struct email_msg {
  char *from;
  rcpt_list to;
  rcpt_list cc;
  rcpt_list bcc;
  char *reply_to;
  char *subject;
  body_list body;
};

/*==========================================================
 * Function Declarations
 *========================================================*/
/* --- in "smtp.c" --- */
int dequalify (char *);
unsigned long int resolve (char*);
void rcpt_list_init (rcpt_list*);
int empty_rcpt_list (rcpt_list);
void body_list_init (body_list*);
int empty_body_list (body_list);
void rcpt_list_insert (rcpt_list*, char*);
void body_list_insert (body_list*, char*);
void free_rcpt_list (rcpt_list*);
void free_body_list (body_list*);
void print_rcpt_list (rcpt_list);
void print_body_list (body_list);
void reset_mail_struct (struct email_msg*);
void mail_struct_init (struct email_msg*);
int send_mail (struct email_msg*, char*, char*, char*);

#endif                                 /* #ifndef _SMTP_H */

/*==========================================================
 * EOF : smtp.h
 *===================*/
