#!/usr/bin/perl -w
#===========================================================
# Program : smsgw.pl
# Author  : Philippe Andersson
# Date    : 24/03/99
# Version : 1.1
# Comment : (c) Les Ateliers du Heron, 1999 for Scitex Europe, S.A.
# Version History :
# * 1.0 (15/03/99) - Initial release.
# * 1.1 (24/03/99) - Fixed a problem with multi-line input.
#===========================================================

use strict;
use diagnostics;
use CGI;

#-----------------------------------------------------------
# Name the global variables
my $userid = "";
my $dest = "";
my $msgtxt = "";

# Create en instance of CGI
my $query = new CGI;

# Send the MIME header
print $query->header ("text/html");

# Grab posted values
$userid = $query->param ("userid");
$dest = $query->param ("dest");
$msgtxt = $query->param ("msgtxt");

# Was at least one field filled-in ?
if (($userid eq "") || ($dest eq "") || ($msgtxt eq "")) {
  print $query->start_html (-title => "Error !");
  print "<H1>Error !</H1>\n";
  print "<P>All fields are required - at least one of them is ";
  print "missing. Please go back and try again.</P>\n";
  print $query->end_html;
  exit;
}

# Check message length
my $txtlen = length ($msgtxt);
if ($txtlen > 160) {
  print $query->start_html (-title => "Error !");
  print "<H1>Error !</H1>\n";
  print "<P>Your message text is longer than 160 char. (now $txtlen). ";
  print "This 160 char. limit is built in the SMS protocol and can't ";
  print "be bypassed. ";
  print "Please go back and edit your message to make it shorter.</P>\n";
  print $query->end_html;
  exit;
}

# Remove newlines from msgtxt (replace them by space)
$msgtxt =~ s/\n/ /g;

#===========================================================
print $query->start_html (-title => "SMS Sending Results");

print "<H1>SMS Sending Results</H1>\n";

#-----------------------------------------------------------
# Submit the sendsms request
my $retval = 0;

$retval = system ("sendsms", "-d$dest", "-u$userid", "-m$msgtxt", "your-server");

if ($retval == 0) {
  print "<P>Message was sent successfully !</P>\n";
}
else {
  print "<P>Failed to deliver message !</P>\n";
}

# End the HTML
print $query->end_html;

#-----------------------------------------------------------

exit;

