/*
 *   Trans92 - programme de communication Linux-TI92
 *
 *   copyright (c) 1998  Emmanuel Beffara
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

//
// dfinition de la classe TI92 pour les communications
//

class TI92 {
 protected:
  int etat,ncl;   // pour le diboguage
  unsigned char _get();
  void _read(unsigned char*,long);
  void _put(unsigned char);
  void _write(unsigned char*,long);
  
  int fd;         // identificateur pour les paramtres de terminal
  fstream *str;   // flux reprsentant la TI
  
  // liste des signaux du protocole

  enum SIGNAL {
    // Rm_* = remote-contrleur, Pl_* = machine pilote
    // Tr_* = transfert entre machines
    
    Rm_BACKUP = 0x0906,         // annonce d'un envoi de backup
    Rm_DEMANDE = 0x0909,        // demande d'un nom de var/rp
                                //   ou des donnes d'une variable
    Rm_DATA = 0x0915,           // donnes d'une variable
    Rm_OK = 0x0956,             // accus de rception ct pilote
    Rm_MERCI = 0x095A,          // aprs rception de la version ROM
    Rm_ALLO = 0x0968,           // test de connection
    Rm_FINDATA = 0x0992,        // fin de l'envoi d'une variable
    Rm_LECTURE = 0x09A2,        // lecture du contenu ou d'une variable
    Rm_ENVOI = 0x09C9,          // envoi d'une variable
    
    Pl_PREMIER = 0x8906,        // envoi du nom du premier rp (???)
    Pl_INFOVAR = 0x8906,        // caractristiques d'une variable
    Pl_VAZY = 0x8909,           // demande des donnes
    Pl_VARIABLE = 0x8915,       // envoi d'un nom de var/rp
    Pl_DATA = 0x8915,           // donnes d'une variable
    Pl_OK = 0x8956,             // accus de rception ct pilot
    Pl_ENCORE = 0x8978,         // indique qu'il reste des vars/rps
    Pl_FINI = 0x8992,           // fin de la liste du contenu
    
    
    Tr_VARIABLE = 0x8906,       // annonce d'une variable
    Tr_VAZY = 0x8909,           // demande des donnes
    Tr_DONNEES = 0x8915,        // envoi des donnes
    Tr_OK = 0x8956,             // accus de rception
    Tr_FINI = 0x8992            // fin de squence
  };


  // Fonctions lmentaires de communication
  //  _wi = mot (16 bits) Big Endian (i comme Intel)
  //  _wm = mot Little Endian (m comme Motorola)
  //  _sg = signal

  void ecris_wi(unsigned short);
  void ecris_wm(unsigned short);
  void ecris_sg(SIGNAL);
  unsigned short lis_wi();
  unsigned short lis_wm();
  void passe() { str->get(); }

  // structure des paquets du protocole

  struct bloc {
    SIGNAL entete;
    short taille;
    unsigned char *data;

    bloc(SIGNAL signal=(SIGNAL)0) { entete=signal; taille=0; data=0; }
    bloc(SIGNAL e, short t, unsigned char *d)
      { entete=e; taille=t; data=d; }
    ~bloc() { /*delete data;*/ }
  };

  
  // envoi / rception de paquets et de signaux

  void env_bloc(bloc&);
  void env_spec(SIGNAL,short);
  void env_sgn(SIGNAL S) { env_spec(S,0); }
  int rec_bloc(bloc&);
  int rec_spec(SIGNAL&,short&);
  
 public:
  
  // liste des types de variables TI

  enum Type {
    EXPR=0x00, LIST=0x04, MAT=0x06, DATA=0x0A, TEXT=0x0B, STR=0x0C,
    GDB=0x0D,  FIG=0x0E,  PIC=0x10, PRGM=0x12, FUNC=0x13, MAC=0x14,
    Backup=0x1D, Groupe=0x1F, Rep=0x1F
  };


  // structure de reprsentation des variables

  struct Variable {
    char nom[18];
    Type type;
    unsigned long taille;
    unsigned char *data;

    Variable() { nom[0]=0; type=(Type)0; taille=0; data=0; }
    ~Variable() { if (data!=0) delete data; }
  };

  
  // tables des suffixes (? dans .92?) et des noms de types

  static const char tSuff[];
  static const char *tTypes[];

  
  // fonctions appeles par les processus rptitifs (surchargeables)

  virtual int recepVar(Variable &);
  //  la rception d'une variable en mode synchronis
  virtual int entreeDir(char*,Type,unsigned short);
  //  la rception d'un entre de rpertoire
  virtual void etapeRecBkp(long);
  //  chaque rception d'un paquet de backup
  virtual void finRecBkp();
  //  la fin de la rception d'un backup
  virtual void etapeEnvBkp(long);
  //  chaque envoi d'un paquet de backup
  virtual void finEnvBkp();
  //  la fin de l'envoi d'un backup

  TI92(const char*);         // constructeur avec nom de priphrique
  virtual ~TI92() { delete str; }    // destructeur
  int operator!() { return !str || !(*str); }  // test de l'tat


  // transmissions synchronises

  int reception();          // attente + rception de variables
  int envoi(Variable&);     // envoi d'une variable
  int finEnvoi();           // fin d'une squence d'envois


  // transmissions pilotes (remote control)

  int testLink();           // test de connection
  int contenu();            // lecture du contenu de la machine
  int version(char*&);      // lecture de la version de la ROM
  int prends(char*,Variable&);  // extraction d'une variable
  int mets(Variable&);      // envoi d'une variable
  int recBackup(Variable&); // backup : sauvegarde
  int envBackup(Variable&); // backup : chargement
};


//
// fonctions de lecture/criture portables
//

         short peekLE_s(unsigned char*);
unsigned short peekLE_us(unsigned char*);
          long peekLE_l(unsigned char*);
 unsigned long peekLE_ul(unsigned char*);
         short peekBE_s(unsigned char*);
unsigned short peekBE_us(unsigned char*);
          long peekBE_l(unsigned char*);
 unsigned long peekBE_ul(unsigned char*);

void pokeLE(unsigned char*,short);
void pokeLE(unsigned char*,unsigned short);
void pokeLE(unsigned char*,long);
void pokeLE(unsigned char*,unsigned long);
void pokeBE(unsigned char*,short);
void pokeBE(unsigned char*,unsigned short);
void pokeBE(unsigned char*,long);
void pokeBE(unsigned char*,unsigned long);

