/*
 *   Trans92 - programme de communication Linux-TI92
 *
 *   copyright (c) 1998  Emmanuel Beffara
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>

#include "ti92.h"

// TRANSMISSION PILOTE - TEST DE LIAISON

int TI92::testLink()
{
  bloc b;
  int r;
  SIGNAL s;
  short v;

  env_bloc(b=bloc(Rm_ALLO));
  r=rec_spec(s,v);
  if (r) return r+100;
  if (s!=Pl_OK) return 201;
  if (v!=0x1000) return 202;
  return 0;
}



// TRANSMISSION PILOTE - LECTURE DU CONTENU

int TI92::contenu()
{
  unsigned char lecture[]={0,0,0,0,0x19,0};

  bloc B;
  int ret,i,j;
  char tamp[9]={0,0,0,0,0,0,0,0,0};

  env_bloc(B=bloc(Rm_LECTURE,6,lecture));

  ret=rec_bloc(B);
  if (ret) return ret+100;
  if (B.entete!=Pl_OK || B.taille!=0) return 201;
  
  ret=rec_bloc(B);
  if (ret) return ret+300;
  if (B.entete!=Pl_PREMIER) return 401;
  if (peekBE_l(B.data)!=0x0000000E) return 402;
  if (B.data[4]!=0x56) return 403;
  if (B.data[5]!=B.taille-6) return 404;
  for (i=B.data[5]-1;i>=0;i--)
    tamp[i]=B.data[6+i];

  for (;;) {
    env_sgn(Rm_OK);
    env_spec(Rm_DEMANDE,0xFFFF);
    
    ret=rec_bloc(B);
    if (ret) return ret+500;
    if (B.entete!=Pl_OK || B.taille!=0) return 601;
  
    ret=rec_bloc(B);
    if (ret) return ret+700;
    if (B.entete!=Pl_VARIABLE) return 801;
    if (B.taille!=18) return 802;
    if (*(long*)B.data!=0) return 803;
    for (j=0;j<8;j++)
      tamp[j]=B.data[4+j];

    ret=entreeDir(tamp, (Type)B.data[12], peekBE_ul(B.data+14));
    if (ret) return ret+900;

    i=B.data[12];

    env_sgn(Rm_OK);

    ret=rec_bloc(B);
    if (ret) return 1000+ret;
    if (B.taille!=0) return 1101;
    if (B.entete==Pl_FINI) {
      env_sgn(Rm_OK);
      return 0;
    } else if (B.entete!=Pl_ENCORE)
      return 1102;
  }
}

int TI92::entreeDir(char*,TI92::Type,unsigned short)
{ return 0; }


// TRANSMISSION PILOTE - LECTURE DE LA VERSION DE LA ROM

int TI92::version(char *&tamp)
{
  int ret,i;

  unsigned char ordre[]={
    0,0,0,0, Backup, 12,
    'm','a','i','n','\\','v','e','r','s','i','o','n'
  };
  bloc B(Rm_LECTURE,18,ordre);
  env_bloc(B);

  ret=rec_bloc(B);
  if (ret) return 100+ret;
  if (B.entete!=Pl_OK) return 201;
  if (B.taille!=0) return 202;
  
  ret=rec_bloc(B);
  if (ret) return 300+ret;
  if (B.entete!=Pl_INFOVAR) return 401;
  if (peekBE_s(B.data+2)!=0) return 402;
  if (B.data[4]!=Backup) return 403;
  if (B.taille!=B.data[5]+6) return 404;
  tamp=new char[B.data[5]+1];
  for (i=0;i<B.data[5];i++)
    tamp[i]=B.data[6+i];
  tamp[i]=0;
  
  env_sgn(Rm_MERCI);
  passe();
  return 0;
}


// TRANSMISSION PILOTE - EXTRACTION DE VARIABLE

int TI92::prends(char *nom,TI92::Variable &V)
{
  int ret,i,j;
  unsigned short tn,tst;

  tn=0;
  while (nom[tn]!=0) {
    V.nom[tn]=nom[tn];
    tn++;
  }
  V.nom[tn]=0;

  unsigned char data[tn+6];
  for (i=0;i<4;i++) data[i]=0;
  data[4]=0;
  data[5]=tn;
  for (i=0;i<tn;i++) data[6+i]=nom[i];
  bloc B(Rm_LECTURE,tn+6,data);
  env_bloc(B);

  ret=rec_bloc(B);
  if (ret) return 100+ret;
  if (B.entete!=Pl_OK) return 201;
  if (B.taille!=0) return 202;
  
  ret=rec_bloc(B);
  if (ret) return 300+ret;
  if (B.entete!=Pl_INFOVAR) return 401;
  V.taille=*(unsigned short*)B.data-2;
  if (peekBE_s(B.data+2)!=0) return 402;
  V.type=(Type)B.data[4];
  if (B.taille!=B.data[5]+6) return 403;
  j=tn-B.data[5];
  for (i=0;i<B.data[5];i++)
    if (B.data[6+i]!=nom[j+i]) return 404;
  
  env_sgn(Rm_OK);
  env_spec(Rm_DEMANDE,-1);

  ret=rec_bloc(B);
  if (ret) return 500+ret;
  if (B.entete!=Pl_OK) return 601;
  if (B.taille!=0) return 602;
  
  ret=rec_bloc(B);
  if (ret) return 700+ret;
  if (B.entete!=Pl_DATA) return 801;
  if (B.taille!=V.taille+6) return 802;
      if (B.data[0]!=0 || B.data[1]!=0 || B.data[2]!=0 ||
	  B.data[3]!=0) return 803;
  tst=peekLE_us(B.data+4);
  if (tst!=V.taille) return 804;
  V.data=new unsigned char[V.taille];
  for (i=0;i<V.taille;i++) V.data[i]=B.data[6+i];

  env_sgn(Rm_OK);

  ret=rec_bloc(B);
  if (ret) return 900+ret;
  if (B.entete!=Pl_FINI) return 1001;
  if (B.taille!=0) return 1002;

  env_sgn(Rm_OK);
  return 0;
}


// TRANSMISSION PILOTE - ENVOI DE VARIABLE

int TI92::mets(TI92::Variable &V)
{
  int ret,i;
  unsigned short tn;

  tn=0;
  for (i=0;i<18 && V.nom[i]!=0;i++) tn++;
  unsigned char *data=new unsigned char[tn+6];
  pokeBE(data,(long)V.taille+2);
  data[4]=(unsigned char)V.type;
  data[5]=(unsigned char)tn;
  for (i=0;i<tn;i++) data[6+i]=V.nom[i];
  bloc B(Rm_ENVOI,tn+6,data);
  env_bloc(B);

  ret=rec_bloc(B);
  if (ret) return 100+ret;
  if (B.entete!=Pl_OK) return 201;
  if (B.taille!=0) return 202;
  ret=rec_bloc(B);
  if (ret) return 300+ret;
  if (B.entete!=Pl_VAZY) return 401;
  if (B.taille!=0) return 402;

  env_sgn(Rm_OK);

  data=new unsigned char[V.taille+6];
  pokeBE(data,0L);
  pokeLE(data+4,(unsigned short)V.taille);
  for (i=0;i<V.taille;i++)
    data[6+i]=V.data[i];
  B=bloc(Pl_DATA,V.taille+6,data);
  env_bloc(B);

  ret=rec_bloc(B);
  if (ret) return 500+ret;
  if (B.entete!=Pl_OK) return 601;
  if (B.taille!=0) return 602;
  
  env_sgn(Rm_FINDATA);

  ret=rec_bloc(B);
  if (ret) return 700+ret;
  if (B.entete!=Pl_OK) return 801;
  if (B.taille!=0) return 802;

  return 0;
}


// TRANSMISSION PILOTE - EXTRACTION DE BACKUP

int TI92::recBackup(Variable &V)
{
  struct Elem {
    struct Elem *suiv;
    unsigned short taille;
    unsigned char *data;
  } *lst, *el;

  int ret;
  long i;
  unsigned short tb,tn;
  long cst;
  bool prem;
  unsigned char *pt;

  unsigned char ordre[]={
    0,0,0,0, Backup, 11,
    'm','a','i','n','\\','b','a','c','k','u','p'
  };
  bloc B(Rm_LECTURE,17,ordre);
  env_bloc(B);

  ret=rec_bloc(B);
  if (ret) return 100+ret;
  if (B.entete!=Pl_OK) return 201;
  if (B.taille!=0) return 202;

  lst=0;
  prem=true;
  V.taille=0;
  for (;;) {
    ret=rec_bloc(B);
    if (ret) return 300+ret;
    if (B.entete==Pl_FINI) break;
    if (B.entete!=Pl_INFOVAR) return 401;
    tb=peekBE_us(B.data);
    if (B.data[2]!=0 || B.data[3]!=0) return 402;
    if (B.data[4]!=Backup) return 403;
    tn=B.data[5];
    if (B.taille!=tn+6) return 404;
    if (prem) {
      for (i=0;i<tn;i++)
        V.nom[i]=B.data[6+i];
      V.nom[tn]=0;
    } else {
      for (i=0;i<tn;i++)
        if (V.nom[i]!=B.data[6+i]) return 405;
      if (V.nom[tn]!=0) return 406;
    }
    
    env_sgn(Rm_OK);
    env_spec(Rm_DEMANDE,0x400);
    
    ret=rec_bloc(B);
    if (ret) return 500+ret;
    if (B.entete!=Pl_OK) return 601;
    if (B.taille!=0) return 602;
    
    ret=rec_bloc(B);
    if (ret) return 700+ret;
    if (B.entete!=Pl_DATA) return 801;
    if (B.taille!=tb+4) return 804;
    if (prem)
      cst=peekBE_l(B.data);
    else
      if (cst!=peekBE_l(B.data)) return 805;
    
    el=new Elem;
    el->suiv=lst;
    el->taille=tb;
    el->data=new unsigned char[tb];
    for (i=0;i<tb;i++)
      el->data[i]=B.data[4+i];
    lst=el;
    V.taille+=tb;
    etapeRecBkp(V.taille);

    env_sgn(Rm_OK);
    prem=false;
  }

  env_sgn(Rm_OK);
  finRecBkp();

  V.data=new unsigned char[V.taille];
  pt=V.data+V.taille;
  for (el=lst;el!=0;el=el->suiv)
    for (i=el->taille-1;i>=0;i--)
      *(--pt)=el->data[i];
  V.type=Backup;

  return 0;
}

void TI92::etapeRecBkp(long) { }
void TI92::finRecBkp() { }


// TRANSMISSION PILOTE - ENVOI DE BACKUP

int TI92::envBackup(Variable &V)
{
  int ret,i;
  short tn,tb,ta;
  long t;
  unsigned char *ordre,*pt;
  SIGNAL s;

  tn=0;
  while (tn<8 && V.nom[tn]!=0) tn++;
  ordre=new unsigned char[6+tn];
  pokeBE(ordre,1024L);
  ordre[4]=Backup;
  ordre[5]=tn;
  for (i=0;i<tn;i++)
    ordre[6+i]=V.nom[i];
  bloc B(Rm_BACKUP,6+tn,ordre);
  env_bloc(B);

  ret=rec_bloc(B);
  if (ret) return 100+ret;
  if (B.entete!=Pl_OK) return 201;
  if (B.taille!=0) return 202;

  t=V.taille;
  pt=V.data;
  while (t>0) {
    if (t>1024) tb=1024;
    else tb=(short)t;

    pokeBE(ordre,(short)tb);
    B=bloc(Rm_BACKUP,6+tn,ordre);
    env_bloc(B);

    ret=rec_bloc(B);
    if (ret) return 300+ret;
    if (B.entete!=Pl_OK) return 401;
    if (B.taille!=0) return 402;

    ret=rec_spec(s,ta);
    if (ret) return 500+ret;
    if (s!=Pl_VAZY) return 401;
    if (tb>t) return 402;

    env_sgn(Rm_OK);
    B=bloc(Rm_DATA,tb,pt);
    env_bloc(B);
    
    ret=rec_bloc(B);
    if (ret) return 500+ret;
    if (B.entete!=Pl_OK) return 601;
    if (B.taille!=0) return 602;

    pt+=tb;
    t-=tb;
    etapeEnvBkp(V.taille-t);
  }

  env_sgn(Rm_FINDATA);
  finEnvBkp();

  return 0;
}

void TI92::etapeEnvBkp(long) { }
void TI92::finEnvBkp() { }
