/*---------------------------------------------------------------------------*\

    FILE....: ADPCM.H
    TYPE....: C Header File
    AUTHOR..: David Rowe
    DATE....: 16/10/97

    ADPCM state variable structure, used to share info between ADPCMINI.C
    and ADPCM.C.  No other modules should include this file as it may change
    if the ADPCM implementation changes.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

	Copyright (C) 1999 Voicetronix Pty Ltd

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

\*---------------------------------------------------------------------------*/

#ifndef __ADPCM__
#define __ADPCM__

#include "..\contypes\contypes.h"

/*-------------------------------------------------------------------------*\

				DEFINES

\*-------------------------------------------------------------------------*/

#define ADMAX	2047		/* maximum ADPCM sample value		   */

typedef struct {
    short pX_;			/* previous decoded sample		   */
    int   index;		/* current index			   */
} ADPCM;

#define CODES	4		/* number of codes in each word */
#define BITS	4		/* number of bits per code */
#define WORD	16		/* number of bits in word */




#endif	/* #ifndef __ADPCM__	*/

