/*---------------------------------------------------------------------------*\

    FILE....: COMP.H
    TYPE....: C Header File
    AUTHOR..: David Rowe
    DATE....: 16/10/97

    Compression functions.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

	Copyright (C) 1999 Voicetronix Pty Ltd

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

\*---------------------------------------------------------------------------*/

#ifndef __COMP__
#define __COMP__

#include "../contypes/contypes.h"

/*--------------------------------------------------------------------------*\

				DEFINES

\*--------------------------------------------------------------------------*/

/*
   Scale factors define the number of right shifts to convert a 16 bit word
   to a format suitable for input to the compression functions.

   For example, the maximum value for mu-law is 8192, therefore to convert
   a 16 word (max 32767) to a maximum of 8192 we shift two places to the
   right.
*/

#define MULAW_SCALE     2	/* scales linear to mulaw	*/
#define ALAW_SCALE      3	/* scales linear to alaw 	*/
#define ADPCM_SCALE     4	/* scales linear to ADPCM 	*/

/*--------------------------------------------------------------------------*\

				FUNCTIONS

\*--------------------------------------------------------------------------*/

/* C versions */

void mulaw_encode(ushort mulaw[], short linear[], ushort sz);
void mulaw_decode(short linear[], ushort mulaw[], ushort sz);

void alaw_encode(ushort alaw[], short linear[], ushort sz);
void alaw_decode(short linear[], ushort alaw[], ushort sz);
void alaw_pack(ushort codes[], ushort packed[], ushort n);
void alaw_unpack(ushort codes[], ushort packed[], ushort n);

void adpcmini_open(void **states);
void adpcmini_close(void *states);
void adpcmini_reset_states(void *states);
void adpcm_encode(void *states, ushort codes[], short X[], ushort n);
void adpcm_decode(void *states, short X_[], ushort codes[], ushort n);

void adpcm_pack(ushort codes[], ushort packed[], ushort n);
void adpcm_unpack(ushort codes[], ushort packed[], ushort n);

/* assembler versions */

void mulawasm_encode(ushort mulaw[], short linear[], ushort sz);
void mulawasm_decode(short linear[], ushort mulaw[], ushort sz);

void alawasm_encode(ushort alaw[], short linear[], ushort sz);
void alawasm_decode(short linear[], ushort alaw[], ushort sz);
void alawasm_decode_lut(short linear[], ushort alaw[], ushort sz);
void alawasm_unpack(ushort codes[], ushort packed[], ushort n);

void adpcmasm_encode(void *states, ushort codes[], short X[], ushort n);
void adpcmasm_decode(void *states, short X_[], ushort codes[], ushort n);
void adpcmasm_pack(ushort codes[], ushort packed[], ushort n);
void adpcmasm_unpack(ushort codes[], ushort packed[], ushort n);

#endif	/* #ifndef __COMP__	*/

