/*--------------------------------------------------------------------------*\

    FILE....: CONTYPES.H
    TYPE....: C Function Header File
    AUTHOR..: David Rowe
    DATE....: 1/10/97

    Commonly used constants and typedefs.

\*--------------------------------------------------------------------------*/

#ifndef __CONTYPES__
#define __CONTYPES__

#include "../contypes/mmreg.h"
#include "../contypes/bp.h"

/*--------------------------------------------------------------------------*\

				DEFINES

\*--------------------------------------------------------------------------*/

/* used with assert to validate arguments */

#define START_BASE	0x300		/* lowest possible base addr	*/
#define	END_BASE	0x400		/* highest possible base addr	*/
#define MAX_LENGTH	0x10000l	/* maximum length for 'C5x mem	*/

/* useful macros to split high and low 16 bits of longs */

#define	LOW(x)		(((long)x)&0xffff)
#define	HIGH(x)		(((long)x)>>16)

/*--------------------------------------------------------------------------*\

				TYPEDEFS

\*--------------------------------------------------------------------------*/

typedef unsigned char byte;
typedef unsigned short ushort;
typedef unsigned short word;
typedef unsigned long ulong;

#endif	/* #ifndef __CONTYPES__	*/

