/*-------------------------------------------------------------------------*\

	FILE........: MMREG.H
	TYPE........: C Header File
	COMPANY.....: VoiceTronix
	AUTHOR......: David Rowe
	DATE CREATED: 14/2/96

	C5x Defines to allow access to memory mapped registers from C.

\*-------------------------------------------------------------------------*/

#ifndef __MMREG__
#define __MMREG__

/* serial port */

#define SPC	*((int*)0x22)		/* C5x serial port control reg	*/
#define DXR	*((int*)0x21)		/* serial port TX data reg	*/
#define DRR	*((int*)0x20)		/* serial port RX data reg	*/
#define XRDY	(SPC & 0x800)		/* ==1 if DXR ready for word	*/

/* interrupts */

#define IMR	*((int*)0x4)		/* interrupt mask register reg	*/
#define PMST	*((int*)0x7)		/* processor mode status reg	*/
#define IFR	*((int*)0x6)		/* interrupt flag register reg	*/

/* timer */

#define PRD	*((int*)0x25)		/* timer period register 	*/
#define TCR	*((int*)0x26)		/* timer control register 	*/

/* Configuration registers for wait state generation in program/data/IO */

#define PDWSR  *((int*)0x28)		/* program/data wait state reg 	*/
#define IOWSR  *((int*)0x29)		/* I/O port wait state reg 	*/
#define CWSR  *((int*)0x2a)		/* control wait state reg 	*/

#endif	/* __MMREG__ */
